/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_638;

public class CullingEngine {
    private static final double MAX_ENTITY_CHECK_VOLUME = 61440.0;
    private final class_310 client;
    private final Set<class_1923> visibleChunks = new HashSet<class_1923>();
    private boolean enabled = true;

    public CullingEngine(class_310 client) {
        this.client = client;
    }

    public void updateVisibleChunks(class_638 world, int renderDistance) {
        this.visibleChunks.clear();
        if (this.client.field_1724 == null) {
            return;
        }
        class_4076 center = class_4076.method_18682((class_2338)this.client.field_1724.method_24515());
        int radius = Math.min(renderDistance, 32);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                this.visibleChunks.add(new class_1923(center.method_18674() + x, center.method_18687() + z));
            }
        }
    }

    public boolean shouldRenderEntity(class_1297 entity) {
        if (!this.enabled) {
            return true;
        }
        if (this.client.method_27022(entity) || entity.method_5733()) {
            return true;
        }
        class_238 box = entity.method_5829();
        if (this.isInfiniteExtentsBox(box) || this.isVeryLargeBox(box)) {
            return true;
        }
        return this.isBoxVisible(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
    }

    public boolean shouldRenderBlockEntity(class_2586 blockEntity) {
        return true;
    }

    private boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        int minX = class_4076.method_32204((double)(x1 - 0.5));
        int minZ = class_4076.method_32204((double)(z1 - 0.5));
        int maxX = class_4076.method_32204((double)(x2 + 0.5));
        int maxZ = class_4076.method_32204((double)(z2 + 0.5));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!this.visibleChunks.contains(new class_1923(x, z))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInfiniteExtentsBox(class_238 box) {
        return Double.isInfinite(box.field_1323) || Double.isInfinite(box.field_1322) || Double.isInfinite(box.field_1321) || Double.isInfinite(box.field_1320) || Double.isInfinite(box.field_1325) || Double.isInfinite(box.field_1324);
    }

    private boolean isVeryLargeBox(class_238 box) {
        double volume = (box.field_1320 - box.field_1323) * (box.field_1325 - box.field_1322) * (box.field_1324 - box.field_1321);
        return volume > 61440.0;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

