/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.particle;

import java.util.List;
import java.util.Random;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.mixin.client.renderer.particle.ParticleAccessor;
import net.carbonmc.graphene.util.VersionChecker;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_702.class})
public abstract class MixinParticleEngine {
    @Unique
    private static final Random RANDOM = new Random();

    @Inject(method={"tickParticle"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickParticle(class_703 particle, CallbackInfo ci) {
        if (VersionChecker.shouldDisableOptimizations() || !((Boolean)CoolConfig.ENABLE_PARTICLE_OPTIMIZATION.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)CoolConfig.ENABLE_PARTICLE_OPTIMIZATION.get()).booleanValue() || !((Boolean)CoolConfig.ENABLE_PARTICLE_LOD.get()).booleanValue()) {
            return;
        }
        if (this.shouldApplyLOD(particle)) {
            this.handleParticleLOD(particle);
        }
    }

    @Unique
    private void handleParticleLOD(class_703 particle) {
        double threshold;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        double distanceSq = particle.method_3064().method_49271(camera.method_19326());
        if (distanceSq > (threshold = ((Double)CoolConfig.LOD_DISTANCE_THRESHOLD.get()).doubleValue()) * threshold) {
            if (RANDOM.nextDouble() > (Double)CoolConfig.LOD_REDUCTION_FACTOR.get()) {
                ((ParticleAccessor)particle).setAlphaAccessor(0.0f);
            } else {
                ((ParticleAccessor)particle).setAlphaAccessor(1.0f);
            }
        } else {
            ((ParticleAccessor)particle).setAlphaAccessor(1.0f);
        }
    }

    @Unique
    private boolean shouldApplyLOD(class_703 particle) {
        String name = particle.getClass().getName().toLowerCase();
        List whitelist = (List)CoolConfig.LOD_PARTICLE_WHITELIST.get();
        List blacklist = (List)CoolConfig.LOD_PARTICLE_BLACKLIST.get();
        for (String black : blacklist) {
            if (!name.contains(black.toLowerCase())) continue;
            return false;
        }
        for (String white : whitelist) {
            if (!name.contains(white.toLowerCase())) continue;
            return true;
        }
        return this.isLowPriorityParticle(particle);
    }

    @Unique
    private boolean isLowPriorityParticle(class_703 particle) {
        String name = particle.getClass().getName().toLowerCase();
        return name.contains("rain") || name.contains("snow") || name.contains("cloud") || name.contains("ash") || name.contains("drip") || name.contains("spore");
    }
}

