/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;

public class KillMobsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"killmobs").requires(source -> source.hasPermission(4))).executes(context -> KillMobsCommand.killMobs((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(context -> KillMobsCommand.killMobs((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets")))));
    }

    private static int killMobs(CommandSourceStack source, Player player) {
        return KillMobsCommand.killMobs(source, Collections.singleton(player));
    }

    private static int killMobs(CommandSourceStack source, Collection<? extends Player> players) {
        int totalKilled = 0;
        for (Player player : players) {
            double range = 50.0;
            Predicate<Entity> isMonster = entity -> entity instanceof Monster && !entity.getType().equals(EntityType.ENDER_DRAGON);
            List monsters = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(range), isMonster);
            int killed = 0;
            for (Entity mob : monsters) {
                mob.discard();
                ++killed;
            }
            totalKilled += killed;
            if (killed > 0) {
                player.sendSystemMessage((Component)Component.literal((String)("\u6e05\u9664\u4e86 " + killed + " \u4e2a\u602a\u7269")));
                continue;
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u9644\u8fd1\u6ca1\u6709\u602a\u7269"));
        }
        return totalKilled;
    }
}

