/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoolConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.BooleanValue ENABLE_PARTICLE_OPTIMIZATION;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PARTICLE_LOD;
    public static final ForgeConfigSpec.DoubleValue LOD_DISTANCE_THRESHOLD;
    public static final ForgeConfigSpec.DoubleValue LOD_REDUCTION_FACTOR;
    public static final ForgeConfigSpec.BooleanValue ENABLE_FIXED_TIMESTEP;
    public static final ForgeConfigSpec.DoubleValue FIXED_TIMESTEP_INTERVAL;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOD_PARTICLE_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOD_PARTICLE_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue fpsoo;
    public static final ForgeConfigSpec.BooleanValue ENABLE_FIXED_LIGHT;
    public static final ForgeConfigSpec.BooleanValue enableReflex;
    public static final ForgeConfigSpec.LongValue reflexOffsetNs;
    public static final ForgeConfigSpec.BooleanValue reflexDebug;
    public static final ForgeConfigSpec.IntValue MAX_FPS;
    public static final ForgeConfigSpec.BooleanValue skipOutlineWhenNoGlowing;
    public static final ForgeConfigSpec.BooleanValue FIX_PEARL_LEAK;
    public static final ForgeConfigSpec.BooleanValue FIX_PROJECTILE_LERP;
    public static final ForgeConfigSpec.BooleanValue ENABLED;
    public static final ForgeConfigSpec.IntValue MAX_STACK_SIZE;
    public static final ForgeConfigSpec.BooleanValue MemoryLeakFix_AE2WTLibCreativeTabLeakFix;
    public static final ForgeConfigSpec.BooleanValue MemoryLeakFix_ScreenshotByteBufferLeakFix;
    public static final ForgeConfigSpec.BooleanValue DEBUG_LOGGING;
    public static ForgeConfigSpec.BooleanValue enableleafCulling;
    public static ForgeConfigSpec.BooleanValue enableCulling;
    public static final ForgeConfigSpec.BooleanValue BambooLight;
    public static final ForgeConfigSpec.BooleanValue REDUCE_FPS_WHEN_INACTIVE;
    public static final ForgeConfigSpec.IntValue INACTIVE_FPS_LIMIT;
    public static final ForgeConfigSpec.BooleanValue REDUCE_RENDER_DISTANCE_WHEN_INACTIVE;
    public static final ForgeConfigSpec.IntValue INACTIVE_RENDER_DISTANCE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_OPTIMIZATION;
    public static final ForgeConfigSpec.EnumValue<RenderMode> RENDER_MODE;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENDER_CHESTS;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_TRAPPED_CHESTS;
    public static final ForgeConfigSpec.IntValue MAX_RENDER_DISTANCE;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENTITY_CLEANUP;
    public static ForgeConfigSpec.BooleanValue enableEntityCulling;
    public static ForgeConfigSpec.BooleanValue enableBlockEntityCulling;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlacklist;
    public static ForgeConfigSpec.BooleanValue enableTickStopping;
    public static ForgeConfigSpec.BooleanValue enableNameTagCulling;
    public static ForgeConfigSpec.BooleanValue optimizeEntities;
    public static ForgeConfigSpec.BooleanValue ite;
    public static ForgeConfigSpec.IntValue horizontalRange;
    public static ForgeConfigSpec.IntValue verticalRange;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> entityWhitelist;
    public static ForgeConfigSpec.BooleanValue tickRaidersInRaid;
    public static ForgeConfigSpec.BooleanValue OpenIO;
    public static ForgeConfigSpec.IntValue maxStackSize;
    public static ForgeConfigSpec.DoubleValue mergeDistance;
    public static ForgeConfigSpec.BooleanValue lockMaxedStacks;
    public static ForgeConfigSpec.IntValue listMode;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> itemList;
    public static ForgeConfigSpec.BooleanValue showStackCount;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> itemWhitelist;
    public static ForgeConfigSpec.BooleanValue NoOpenGLError;
    public static ForgeConfigSpec SPEC;

    public static boolean isCullingEnabled() {
        return (Boolean)enableCulling.get();
    }

    public static boolean isEntityCullingEnabled() {
        return CoolConfig.isCullingEnabled() && (Boolean)enableEntityCulling.get() != false;
    }

    public static boolean isBlockEntityCullingEnabled() {
        return CoolConfig.isCullingEnabled() && (Boolean)enableBlockEntityCulling.get() != false;
    }

    public static boolean isTickStoppingEnabled() {
        return CoolConfig.isCullingEnabled() && (Boolean)enableTickStopping.get() != false;
    }

    public static boolean isNameTagCullingEnabled() {
        return CoolConfig.isCullingEnabled() && (Boolean)enableNameTagCulling.get() != false;
    }

    public static List<? extends String> getEntityBlacklist() {
        return (List)entityBlacklist.get();
    }

    static {
        BUILDER.push("\u51cf\u5c11\u4e0d\u5fc5\u8981\u7684\u65e5\u5fd7 | NoLog");
        NoOpenGLError = BUILDER.comment("\u53d6\u6d88OpenGL\u9519\u8bef\u65e5\u5fd7").define("disable opengl error log", true);
        BUILDER.pop();
        BUILDER.push("Light");
        ENABLE_FIXED_LIGHT = BUILDER.comment("\u5149\u7167\u4f18\u5316").define("enableFixedLight", true);
        BambooLight = BUILDER.comment("\u7af9\u5b50\u5149\u7167\u4f18\u5316").define("enablebambooFixedLight", true);
        BUILDER.pop();
        BUILDER.push("Reflex");
        enableReflex = BUILDER.comment("\u542f\u7528\u7c7b\u4f3c NVIDIA Reflex \u7684\u52a8\u6001\u4f4e\u5ef6\u8fdf\u8c03\u5ea6").define("enableReflex", true);
        reflexOffsetNs = BUILDER.comment(new String[]{"Reflex \u5fae\u8c03\u7b49\u5f85\u65f6\u95f4\uff08\u7eb3\u79d2\uff09\u3002", "GPU \u5403\u4e0d\u6ee1\u5c31\u52a0\u6b63\u6570\uff1b\u961f\u5217\u5806\u79ef\u5c31\u52a0\u8d1f\u6570\u3002"}).defineInRange("reflexOffsetNs", 0L, -1000000L, 1000000L);
        MAX_FPS = BUILDER.comment("Hard framerate cap (0 = disable)").defineInRange("maxFps", 0, 0, 1000);
        reflexDebug = BUILDER.comment("\u5728\u65e5\u5fd7\u4e2d\u8f93\u51fa\u6bcf\u5e27\u7b49\u5f85\u65f6\u95f4\uff0c\u65b9\u4fbf\u8c03\u8bd5").define("reflexDebug", false);
        BUILDER.pop();
        BUILDER.push("\u7c92\u5b50\u4f18\u5316 | particle Optimization");
        ENABLE_PARTICLE_OPTIMIZATION = BUILDER.comment(new String[]{"\u542f\u7528\u7c92\u5b50\u7cfb\u7edf\u4f18\u5316", "Enable particle system optimizations"}).define("enableParticleOptimization", true);
        ENABLE_PARTICLE_LOD = BUILDER.comment(new String[]{"\u542f\u7528\u7c92\u5b50LOD\u7cfb\u7edf (Level of Detail)", "Enable particle LOD system (Level of Detail)"}).define("enableParticleLOD", true);
        LOD_DISTANCE_THRESHOLD = BUILDER.comment(new String[]{"LOD\u8ddd\u79bb\u9608\u503c (\u65b9\u5757)", "Distance threshold for LOD reduction (blocks)"}).defineInRange("lodDistanceThreshold", 16.0, 4.0, 64.0);
        LOD_REDUCTION_FACTOR = BUILDER.comment(new String[]{"LOD\u51cf\u5c11\u56e0\u5b50 (0.0-1.0)", "Reduction factor for LOD (0.0-1.0)"}).defineInRange("lodReductionFactor", 0.3, 0.0, 1.0);
        ENABLE_FIXED_TIMESTEP = BUILDER.comment(new String[]{"\u542f\u7528\u56fa\u5b9a\u65f6\u95f4\u6b65\u957f", "Enable fixed timestep for particle physics"}).define("enableFixedTimestep", false);
        FIXED_TIMESTEP_INTERVAL = BUILDER.comment(new String[]{"\u56fa\u5b9a\u65f6\u95f4\u6b65\u957f\u95f4\u9694 (\u79d2)", "Fixed timestep interval in seconds"}).defineInRange("fixedTimestepInterval", 0.05, 0.001, 0.1);
        LOD_PARTICLE_WHITELIST = BUILDER.comment(new String[]{"\u59cb\u7ec8\u5e94\u7528LOD\u7684\u7c92\u5b50\u7c7b\u578b (\u5373\u4f7f\u4e0d\u5728\u4f4e\u4f18\u5148\u7ea7\u5217\u8868)", "particle types that always use LOD (even iface not low priority)"}).defineList("lodParticleWhitelist", List.of("minecraft:rain", "minecraft:smoke"), o -> o instanceof String);
        LOD_PARTICLE_BLACKLIST = BUILDER.comment(new String[]{"\u4ece\u4e0d\u5e94\u7528LOD\u7684\u7c92\u5b50\u7c7b\u578b", "particle types that never use LOD"}).defineList("lodParticleBlacklist", List.of("minecraft:portal", "minecraft:enchant"), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.comment("\u6811\u53f6\u5254\u9664").push("leaf culling");
        enableleafCulling = BUILDER.comment("enableleafculling").define("enableCulling", true);
        BUILDER.comment("\u5b9e\u4f53\u5254\u9664").push("culling");
        enableCulling = BUILDER.comment("Master switch for entity culling functionality. If disabled, all culling features are turned off.").define("enableCulling", true);
        enableEntityCulling = BUILDER.comment("Enable entity culling").define("enableEntityCulling", true);
        enableBlockEntityCulling = BUILDER.comment("Enable shapes entity culling").define("enableBlockEntityCulling", true);
        entityBlacklist = BUILDER.comment("Entity blacklist using namespace patterns (e.g. 'minecraft:*' to blacklist all vanilla entities)").defineList("entityBlacklist", Arrays.asList("minecraft:player", "minecraft:villager"), obj -> obj instanceof String);
        enableTickStopping = BUILDER.comment("Stop ticking for culled entities").define("enableTickStopping", false);
        enableNameTagCulling = BUILDER.comment("Cull name tags for hidden entities").define("enableNameTagCulling", true);
        BUILDER.pop();
        BUILDER.push("\u9ad8\u7248\u672cmc\u4f18\u5316\u79fb\u690d");
        FIX_PEARL_LEAK = BUILDER.define("fixPearlChunkLeak", true);
        FIX_PROJECTILE_LERP = BUILDER.define("fixProjectileInterpolation", true);
        BUILDER.pop();
        BUILDER.push("\u6e32\u67d3\u4f18\u5316 | Rendering Optimization");
        skipOutlineWhenNoGlowing = BUILDER.comment("Skip outline rendering when no glowing entities are in view").define("skipOutlineWhenNoGlowing", true);
        fpsoo = BUILDER.comment("\u51cf\u5c11\u6e32\u67d3\u5ef6\u8fdf").define("fpsoo", true);
        BUILDER.pop();
        BUILDER.push("chest_optimization");
        ENABLE_OPTIMIZATION = BUILDER.comment("Enable chest rendering optimization").define("enableOptimization", true);
        RENDER_MODE = BUILDER.comment("Rendering mode").defineEnum("renderMode", (Enum)RenderMode.SIMPLE);
        OPTIMIZE_ENDER_CHESTS = BUILDER.comment("Optimize ender chests").define("optimizeEnderChests", true);
        OPTIMIZE_TRAPPED_CHESTS = BUILDER.comment("Optimize trapped chests").define("optimizeTrappedChests", false);
        MAX_RENDER_DISTANCE = BUILDER.comment("Max render distance in chunks").defineInRange("maxRenderDistance", 32, 1, 128);
        BUILDER.pop();
        BUILDER.push("\u975e\u6d3b\u52a8\u72b6\u6001\u4f18\u5316 | Inactive Optimization");
        REDUCE_FPS_WHEN_INACTIVE = BUILDER.comment(new String[]{"\u7a97\u53e3\u975e\u6d3b\u52a8\u65f6\u964d\u4f4eFPS", "Enable FPS reduction when window is inactive"}).define("reduceFpsWhenInactive", false);
        INACTIVE_FPS_LIMIT = BUILDER.comment(new String[]{"\u975e\u6d3b\u52a8\u72b6\u6001FPS\u9650\u5236 (5-60)", "FPS limit when window is inactive (5-60)"}).defineInRange("inactiveFpsLimit", 10, 5, 60);
        REDUCE_RENDER_DISTANCE_WHEN_INACTIVE = BUILDER.comment(new String[]{"\u7a97\u53e3\u975e\u6d3b\u52a8\u65f6\u964d\u4f4e\u6e32\u67d3\u8ddd\u79bb", "Enable render distance reduction when window is inactive"}).define("reduceRenderDistanceWhenInactive", false);
        INACTIVE_RENDER_DISTANCE = BUILDER.comment(new String[]{"\u975e\u6d3b\u52a8\u72b6\u6001\u6e32\u67d3\u8ddd\u79bb (2-12)", "Render distance when window is inactive (2-12)"}).defineInRange("inactiveRenderDistance", 2, 2, 12);
        BUILDER.pop();
        BUILDER.comment("\u5b9e\u4f53\u4f18\u5316 | Entity Optimization").push("entity_optimization");
        BUILDER.push("\u5b9e\u4f53Tick\u4f18\u5316 | Entity Tick Optimization");
        optimizeEntities = BUILDER.comment(new String[]{"\u542f\u7528\u5b9e\u4f53tick\u4f18\u5316", "Enable entity tick optimization"}).define("optimizeEntities", true);
        horizontalRange = BUILDER.comment(new String[]{"\u6c34\u5e73\u68c0\u6d4b\u8303\u56f4(\u65b9\u5757)", "Horizontal detection range (blocks)"}).defineInRange("horizontalRange", 64, 1, 256);
        verticalRange = BUILDER.comment(new String[]{"\u5782\u76f4\u68c0\u6d4b\u8303\u56f4(\u65b9\u5757)", "Vertical detection range (blocks)"}).defineInRange("verticalRange", 32, 1, 256);
        ite = BUILDER.comment("\u505c\u6b62tick\u5b9e\u4f53\u53d6\u6d88\u6e32\u67d3").define("ite", true);
        BUILDER.pop();
        BUILDER.push("\u5b9e\u4f53\u767d\u540d\u5355 | Entity Whitelist");
        OPTIMIZE_ENTITY_CLEANUP = BUILDER.comment(new String[]{"\u542f\u7528\u6b7b\u4ea1\u5b9e\u4f53\u6e05\u7406", "Enable dead entity cleanup"}).define("entityCleanup", true);
        entityWhitelist = BUILDER.comment(new String[]{"\u5b9e\u4f53\u767d\u540d\u5355\uff08\u59cb\u7ec8\u4e0d\u4f18\u5316\uff09", "Entity whitelist (always optimized)"}).defineList("entityWhitelist", List.of("minecraft:ender_dragon"), o -> true);
        BUILDER.pop();
        BUILDER.push("\u88ad\u51fb\u4e8b\u4ef6 | Raid Events");
        tickRaidersInRaid = BUILDER.comment(new String[]{"\u5728\u88ad\u51fb\u4e2d\u4fdd\u6301\u88ad\u51fb\u8005tick", "Keep raider ticking during raids"}).define("tickRaidersInRaid", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u7269\u54c1\u4f18\u5316 | Item Optimization").push("item_optimization");
        OpenIO = BUILDER.comment(new String[]{"\u542f\u7528\u7269\u54c1\u4f18\u5316\u7cfb\u7edf", "Enable item optimization system"}).define("OpenIO", true);
        BUILDER.push("\u5806\u53e0\u5408\u5e76 | Stack Merging");
        maxStackSize = BUILDER.comment(new String[]{"\u5408\u5e76\u7269\u54c1\u7684\u6700\u5927\u5806\u53e0\u6570\u91cf\uff08-1\u8868\u793a\u65e0\u9650\u5236\uff09", "Maximum stack size for merged items (-1 = no limit)"}).defineInRange("maxStackSize", -1, -1, Integer.MAX_VALUE);
        mergeDistance = BUILDER.comment(new String[]{"\u7269\u54c1\u5408\u5e76\u68c0\u6d4b\u534a\u5f84\uff08\u65b9\u5757\uff09", "Item merge detection radius in blocks"}).defineInRange("mergeDistance", 1.5, 0.1, 10.0);
        showStackCount = BUILDER.comment(new String[]{"\u5728\u5408\u5e76\u540e\u7684\u7269\u54c1\u4e0a\u663e\u793a\u5806\u53e0\u6570\u91cf", "Show stack count on merged items"}).define("showStackCount", true);
        lockMaxedStacks = BUILDER.comment(new String[]{"\u5f53\u7269\u54c1\u5806\u53e0\u8fbe\u5230\u6700\u5927\u65f6\u9501\u5b9a\uff0c\u4e0d\u518d\u53c2\u4e0e\u5408\u5e76", "Lock stacks that have reached the maximum size to prevent further merging"}).define("lockMaxedStacks", true);
        BUILDER.pop();
        BUILDER.push("\u81ea\u5b9a\u4e49\u5806\u53e0 | Custom Stack Size");
        ENABLED = BUILDER.comment(new String[]{"\u542f\u7528\u81ea\u5b9a\u4e49\u5806\u53e0\u5927\u5c0f-\u8fd9\u91cc\u6539\u4e86\u51fa\u95ee\u9898\u7684\u6539\u56de\u53bb\uff0c\u8bb0\u4f4f\u8fd9\u53e5\u8bdd\uff01\u7279\u522b\u662f\u79d1\u6280\u670d\u8150\u7af9\uff01", "Enable custom stack sizes"}).define("enabled", false);
        MAX_STACK_SIZE = BUILDER.comment(new String[]{"\u6700\u5927\u7269\u54c1\u5806\u53e0\u5927\u5c0f (1-9999)", "Maximum item stack size (1-9999)"}).defineInRange("maxStackSize", 64, 1, 9999);
        BUILDER.pop();
        BUILDER.push("\u7269\u54c1\u5217\u8868 | Item Lists");
        listMode = BUILDER.comment(new String[]{"0: \u7981\u7528 1: \u767d\u540d\u5355\u6a21\u5f0f 2: \u9ed1\u540d\u5355\u6a21\u5f0f", "0: Disabled, 1: Whitelist, 2: Blacklist"}).defineInRange("listMode", 0, 0, 2);
        itemList = BUILDER.comment(new String[]{"\u767d\u540d\u5355/\u9ed1\u540d\u5355\u4e2d\u7684\u7269\u54c1\u6ce8\u518c\u540d\u5217\u8868", "Item registry names for whitelist/blacklist"}).defineList("itemList", Collections.emptyList(), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.push("\u7269\u54c1\u5b9e\u4f53 | Item Entities");
        itemWhitelist = BUILDER.comment(new String[]{"\u7269\u54c1\u5b9e\u4f53\u767d\u540d\u5355", "Item entity whitelist"}).defineList("itemWhitelist", List.of("minecraft:diamond"), o -> true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.comment("\u5185\u5b58\u4f18\u5316 | Memory Optimization").push("memory_optimization");
        MemoryLeakFix_AE2WTLibCreativeTabLeakFix = BUILDER.comment(new String[]{"\u5185\u5b58\u6cc4\u6f0f\u4fee\u590d_AE2WTLibCreativeTabLeakFix", "MemoryLeakFix_AE2WTLib"}).define("enablememoryleakfixae2", true);
        MemoryLeakFix_ScreenshotByteBufferLeakFix = BUILDER.comment(new String[]{"\u5185\u5b58\u6cc4\u6f0f\u4fee\u590d_ScreenshotByteBufferLeakFix", "MemoryLeakFix_ScreenshotByteBufferLeakFix"}).define("enablememoryleakfixScreenshotByteBufferLeakFix", true);
        BUILDER.pop();
        BUILDER.comment("\u8c03\u8bd5\u9009\u9879 | Debug Options").push("debug");
        DEBUG_LOGGING = BUILDER.comment(new String[]{"\u542f\u7528\u8c03\u8bd5\u65e5\u5fd7", "Enable debug logging"}).define("debug", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static enum RenderMode {
        SIMPLE,
        VANILLA;

    }
}

