/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.chest;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntityRenderDispatcher.class})
public abstract class OptimizedChestRenderer {
    private BlockPos lastPlayerPos;
    private long lastCheckTime;

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private <E extends BlockEntity> void handleRendering(E entity, CallbackInfoReturnable<BlockEntityRenderer<E>> cir) {
        if (!this.shouldOptimizeRendering(entity)) {
            return;
        }
        try {
            BlockPos pos = entity.getBlockPos();
            Level level = entity.getLevel();
            if (!this.isValidPosition(level, pos)) {
                this.logDebug("\u65e0\u6548\u7684\u7bb1\u5b50\u4f4d\u7f6e\u6216\u4e16\u754c: " + String.valueOf(pos));
                return;
            }
            if (!this.shouldRenderChest(level, pos)) {
                cir.setReturnValue(null);
            }
        }
        catch (Exception e) {
            this.logDebug("\u4f18\u5316\u7bb1\u5b50\u6e32\u67d3\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    private <E extends BlockEntity> boolean shouldOptimizeRendering(E entity) {
        return (Boolean)CoolConfig.ENABLE_OPTIMIZATION.get() != false && entity != null && !entity.isRemoved() && entity.getLevel() != null && (entity instanceof ChestBlockEntity || entity instanceof EnderChestBlockEntity && (Boolean)CoolConfig.OPTIMIZE_ENDER_CHESTS.get() != false);
    }

    private boolean isValidPosition(Level level, BlockPos pos) {
        return level != null && pos != null;
    }

    private boolean shouldRenderChest(Level level, BlockPos chestPos) {
        BlockPos playerPos = this.getCachedPlayerPosition(level, chestPos);
        if (playerPos == null) {
            return false;
        }
        return !this.isBeyondRenderDistance(chestPos, playerPos);
    }

    private BlockPos getCachedPlayerPosition(Level level, BlockPos chestPos) {
        long currentTime = System.currentTimeMillis();
        if (this.lastPlayerPos == null || currentTime - this.lastCheckTime > 500L) {
            Player player = this.getNearestPlayerSafely(level, chestPos);
            this.lastPlayerPos = player != null ? player.blockPosition() : null;
            this.lastCheckTime = currentTime;
        }
        return this.lastPlayerPos;
    }

    private Player getNearestPlayerSafely(Level level, BlockPos pos) {
        try {
            return level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)((Integer)CoolConfig.MAX_RENDER_DISTANCE.get() * 16), false);
        }
        catch (Exception e) {
            this.logDebug("\u83b7\u53d6\u6700\u8fd1\u73a9\u5bb6\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private boolean isBeyondRenderDistance(BlockPos chestPos, BlockPos playerPos) {
        boolean beyond;
        double maxDistance = (Integer)CoolConfig.MAX_RENDER_DISTANCE.get() * 16;
        double distanceSq = chestPos.distSqr((Vec3i)playerPos);
        boolean bl = beyond = distanceSq > maxDistance * maxDistance;
        if (beyond) {
            this.logDebug("\u8df3\u8fc7\u8fdc\u5904\u7bb1\u5b50: " + String.valueOf(chestPos) + " \u8ddd\u79bb: " + Math.sqrt(distanceSq));
        }
        return beyond;
    }

    private void logDebug(String message) {
        if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
            System.out.println("[Graphene] " + message);
        }
    }
}

