/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.gl;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.Cleaner;
import net.carbonmc.graphene.gl.CleanupAction;
import net.carbonmc.graphene.gl.FramebufferFixer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={RenderTarget.class})
public abstract class FramebufferMixin
implements FramebufferFixer {
    private static final Cleaner CLEANER = Cleaner.create();
    private final Cleaner.Cleanable cleanable = CLEANER.register(this, new CleanupAction(() -> RenderSystem.recordRenderCall(this::graphene$cleanup)));
    @Shadow
    public int frameBufferId;
    @Shadow
    protected int colorTextureId;
    @Shadow
    protected int depthBufferId;

    @Override
    public void graphene$cleanup() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.colorTextureId > -1) {
            TextureUtil.releaseTextureId((int)this.colorTextureId);
            this.colorTextureId = -1;
        }
        if (this.depthBufferId > -1) {
            TextureUtil.releaseTextureId((int)this.depthBufferId);
            this.depthBufferId = -1;
        }
        if (this.frameBufferId > -1) {
            GlStateManager._glDeleteFramebuffers((int)this.frameBufferId);
            this.frameBufferId = -1;
        }
    }
}

