/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.light;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.function.LongPredicate;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamicGraphMinFixedPoint.class})
public abstract class MixinDynamicGraphMinFixedPoint {
    @Mutable
    @Shadow
    @Final
    private Long2ByteMap computedLevels;

    @Shadow
    protected abstract void removeFromQueue(long var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(int levelCount, int queueSize, int mapCapacity, CallbackInfo ci) {
        if (!((Boolean)CoolConfig.ENABLE_FIXED_LIGHT.get()).booleanValue()) {
            return;
        }
        Long2ByteOpenHashMap map = new Long2ByteOpenHashMap(mapCapacity, 0.75f);
        map.defaultReturnValue((byte)-1);
        this.computedLevels = map;
    }

    @Inject(method={"removeIf"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeIf(LongPredicate predicate, CallbackInfo ci) {
        if (!((Boolean)CoolConfig.ENABLE_FIXED_LIGHT.get()).booleanValue()) {
            return;
        }
        ci.cancel();
        LongSet keys = this.computedLevels.keySet();
        LongIterator it = keys.iterator();
        while (it.hasNext()) {
            long pos = it.nextLong();
            if (!predicate.test(pos)) continue;
            this.removeFromQueue(pos);
        }
    }
}

