/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.culling;

import com.mojang.blaze3d.vertex.PoseStack;
import net.carbonmc.graphene.accessor.EntityRendererAccessor;
import net.carbonmc.graphene.client.GrapheneClient;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.iface.EntityVisibility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Unique
    private final Minecraft graphene$mc = Minecraft.getInstance();
    @Final
    @Shadow
    private EntityRenderDispatcher entityRenderDispatcher;

    @Inject(method={"renderEntity"}, at={@At(value="TAIL")}, cancellable=true)
    private void graphene$skipCulledEntityButMaybeRenderNameTag(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers, CallbackInfo ci) {
        if (!CoolConfig.isCullingEnabled()) {
            return;
        }
        GrapheneClient client = GrapheneClient.instance;
        if (client == null || !(entity instanceof EntityVisibility)) {
            return;
        }
        EntityVisibility cullable = (EntityVisibility)entity;
        if (cullable.graphene$isForcedVisible() || entity.noCulling) {
            cullable.graphene$setOutOfCamera(false);
            return;
        }
        if (client.shouldSkipEntity(entity)) {
            if (!CoolConfig.isNameTagCullingEnabled() && matrices != null && consumers != null && this.graphene$shouldRenderNameTag(entity)) {
                this.graphene$renderNameTag(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, consumers);
            }
            ci.cancel();
            return;
        }
        cullable.graphene$setOutOfCamera(false);
    }

    @Unique
    private boolean graphene$shouldRenderNameTag(Entity entity) {
        EntityRendererAccessor accessor;
        EntityRenderer renderer = this.entityRenderDispatcher.getRenderer(entity);
        return renderer instanceof EntityRendererAccessor && (accessor = (EntityRendererAccessor)renderer).graphene_shouldShowName(entity);
    }

    @Unique
    private void graphene$renderNameTag(Entity entity, double camX, double camY, double camZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers) {
        EntityRenderer renderer = this.entityRenderDispatcher.getRenderer(entity);
        if (!(renderer instanceof EntityRendererAccessor)) {
            return;
        }
        EntityRendererAccessor accessor = (EntityRendererAccessor)renderer;
        double x = Mth.lerp((double)tickDelta, (double)entity.xOld, (double)entity.getX()) - camX;
        double y = Mth.lerp((double)tickDelta, (double)entity.yOld, (double)entity.getY()) - camY;
        double z = Mth.lerp((double)tickDelta, (double)entity.zOld, (double)entity.getZ()) - camZ;
        Vec3 offset = renderer.getRenderOffset(entity, tickDelta);
        matrices.pushPose();
        matrices.translate(x + offset.x, y + offset.y, z + offset.z);
        accessor.graphene_renderNameTag(entity, entity.getDisplayName(), matrices, consumers, this.entityRenderDispatcher.getPackedLightCoords(entity, tickDelta));
        matrices.popPose();
    }
}

