/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.other;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.Deque;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PoseStack.class})
public class MixinPoseStack {
    private final Deque<PoseStack.Pose> pool = new ArrayDeque<PoseStack.Pose>();
    @Shadow
    @Final
    private Deque<PoseStack.Pose> poseStack;

    private static PoseStack.Pose createPose(Matrix4f pose, Matrix3f normal) {
        try {
            Constructor ctr = PoseStack.Pose.class.getDeclaredConstructor(Matrix4f.class, Matrix3f.class);
            ctr.setAccessible(true);
            return (PoseStack.Pose)ctr.newInstance(pose, normal);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create PoseStack.Pose", e);
        }
    }

    @Inject(method={"pushPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPush(CallbackInfo ci) {
        PoseStack.Pose top = this.poseStack.getLast();
        PoseStack.Pose reused = this.pool.pollLast();
        if (reused == null) {
            Matrix4f newPos = new Matrix4f().set((Matrix4fc)top.pose());
            Matrix3f newNorm = new Matrix3f().set((Matrix3fc)top.normal());
            reused = MixinPoseStack.createPose(newPos, newNorm);
        } else {
            reused.pose().set((Matrix4fc)top.pose());
            reused.normal().set((Matrix3fc)top.normal());
        }
        this.poseStack.addLast(reused);
        ci.cancel();
    }

    @Inject(method={"popPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPop(CallbackInfo ci) {
        this.pool.addLast(this.poseStack.removeLast());
        ci.cancel();
    }
}

