/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.sky;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.material.FluidState;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinWorldRenderer {
    private static final int CHECK_INTERVAL = 5;
    private final BlockPos.MutableBlockPos lastPos = new BlockPos.MutableBlockPos();
    private final AtomicBoolean wasUnderwater = new AtomicBoolean(false);
    private int tickCounter = 0;

    @Inject(method={"renderSky"}, at={@At(value="HEAD")}, cancellable=true)
    private void graphene$cancelSkyWhenUnderwater(Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, Camera camera, boolean isFoggy, Runnable skyFogSetup, CallbackInfo ci) {
        if (++this.tickCounter % 5 == 0 || !this.lastPos.equals((Object)camera.getBlockPosition())) {
            BlockPos current = camera.getBlockPosition();
            this.lastPos.set((Vec3i)current);
            FluidState fluid = camera.getEntity().level().getFluidState(current);
            this.wasUnderwater.set(fluid.is(FluidTags.WATER));
        }
        if (this.wasUnderwater.get()) {
            ci.cancel();
        }
    }
}

