/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.other;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCollisionContext.class})
public class EntityCollisionContextMixin {
    @Mutable
    @Shadow
    @Final
    private ItemStack heldItem;
    @Mutable
    @Shadow
    @Final
    private Predicate<FluidState> canStandOnFluid;
    @Shadow
    @Final
    private Entity entity;
    @Unique
    private boolean graphene$heldItemInitialized = false;
    @Unique
    private boolean graphene$fluidPredicateInitialized = false;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="RETURN")})
    private void onConstructed(Entity entity, CallbackInfo ci) {
        this.heldItem = null;
        this.canStandOnFluid = null;
    }

    @Inject(method={"isHoldingItem"}, at={@At(value="HEAD")})
    private void initHeldItemOnDemand(Item item, CallbackInfoReturnable<Boolean> cir) {
        if (!this.graphene$heldItemInitialized) {
            this.graphene$initializeHeldItem();
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")})
    private void initFluidPredicateOnDemand(FluidState p_205115_, FluidState p_205116_, CallbackInfoReturnable<Boolean> cir) {
        if (!this.graphene$fluidPredicateInitialized) {
            this.graphene$initializeFluidPredicate();
        }
    }

    @Unique
    private void graphene$initializeHeldItem() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.heldItem = livingEntity.getMainHandItem();
        } else {
            this.heldItem = ItemStack.EMPTY;
        }
        this.graphene$heldItemInitialized = true;
    }

    @Unique
    private void graphene$initializeFluidPredicate() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.canStandOnFluid = arg_0 -> ((LivingEntity)livingEntity).canStandOnFluid(arg_0);
        } else {
            this.canStandOnFluid = fluid -> false;
        }
        this.graphene$fluidPredicateInitialized = true;
    }
}

