/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.stack;

import java.util.Comparator;
import java.util.List;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    private static final int MERGE_COOLDOWN_TICKS = 5;
    private static final int DEFAULT_MAX_STACK = 2147483547;
    @Unique
    private int lastMergeTick = -1;

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setItem(ItemStack var1);

    @Shadow
    public abstract void setExtendedLifetime();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.updateStackDisplay(self);
        if (this.shouldAttemptMerge(self)) {
            this.lastMergeTick = (int)self.level().getGameTime();
            this.tryMergeItems(self);
        }
    }

    @Unique
    private boolean shouldProcess() {
        return (Boolean)CoolConfig.OpenIO.get() != false && !((ItemEntity)this).level().isClientSide;
    }

    @Unique
    private boolean shouldAttemptMerge(ItemEntity self) {
        long gameTime = self.level().getGameTime();
        return this.lastMergeTick == -1 || gameTime - (long)this.lastMergeTick >= 5L;
    }

    @Unique
    private void tryMergeItems(ItemEntity self) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue()) {
            return;
        }
        ItemStack stack = self.getItem();
        int maxStack = this.getEffectiveMaxStackSize();
        if (stack.getCount() >= maxStack) {
            return;
        }
        List<ItemEntity> nearby = this.findMergeableItems(self);
        if (nearby.isEmpty()) {
            return;
        }
        this.performMerge(self, stack, maxStack, nearby);
    }

    @Unique
    private int getEffectiveMaxStackSize() {
        int configMax = (Integer)CoolConfig.maxStackSize.get();
        return configMax > 0 ? configMax : 2147483547;
    }

    @Unique
    private List<ItemEntity> findMergeableItems(ItemEntity self) {
        double mergeDistance = (Double)CoolConfig.mergeDistance.get();
        int listMode = (Integer)CoolConfig.listMode.get();
        List itemList = (List)CoolConfig.itemList.get();
        ItemStack selfStack = self.getItem();
        List nearby = self.level().getEntitiesOfClass(ItemEntity.class, self.getBoundingBox().inflate(mergeDistance), e -> this.isValidMergeTarget(self, (ItemEntity)e, listMode, itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((ItemEntity)self).distanceToSqr(arg_0)));
        return nearby;
    }

    @Unique
    private void performMerge(ItemEntity self, ItemStack stack, int maxStack, List<ItemEntity> nearby) {
        int remainingSpace = maxStack - stack.getCount();
        for (ItemEntity other : nearby) {
            if (remainingSpace <= 0) break;
            ItemStack otherStack = other.getItem();
            int transfer = Math.min(otherStack.getCount(), remainingSpace);
            stack.grow(transfer);
            self.setItem(stack);
            self.setExtendedLifetime();
            this.handleOtherStackAfterTransfer(other, otherStack, transfer);
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void handleOtherStackAfterTransfer(ItemEntity other, ItemStack otherStack, int transfer) {
        if (otherStack.getCount() == transfer) {
            other.discard();
        } else {
            otherStack.shrink(transfer);
            other.setItem(otherStack);
            this.updateStackDisplay(other);
        }
    }

    @Unique
    private void updateStackDisplay(ItemEntity entity) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue() || !((Boolean)CoolConfig.showStackCount.get()).booleanValue()) {
            this.clearDisplay(entity);
            return;
        }
        ItemStack stack = entity.getItem();
        if (stack.getCount() > 1) {
            this.setStackCountDisplay(entity, stack.getCount());
        } else {
            this.clearDisplay(entity);
        }
    }

    @Unique
    private void setStackCountDisplay(ItemEntity entity, int count) {
        MutableComponent countText = Component.literal((String)("\u00d7" + count)).withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.BOLD);
        entity.setCustomName((Component)countText);
        entity.setCustomNameVisible(true);
    }

    @Unique
    private void clearDisplay(ItemEntity entity) {
        entity.setCustomName(null);
        entity.setCustomNameVisible(false);
    }

    @Unique
    private boolean isValidMergeTarget(ItemEntity self, ItemEntity other, int listMode, List<? extends String> itemList) {
        ItemStack otherStack;
        if (self == other || other.isRemoved()) {
            return false;
        }
        ItemStack selfStack = self.getItem();
        return this.isSameItem(selfStack, otherStack = other.getItem()) && this.isMergeAllowed(otherStack, listMode, itemList) && ((Boolean)CoolConfig.lockMaxedStacks.get() == false || otherStack.getCount() < this.getEffectiveMaxStackSize());
    }

    @Unique
    private boolean isSameItem(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    @Unique
    private boolean isMergeAllowed(ItemStack stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (id == null) {
            return false;
        }
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 ? inList : !inList;
    }
}

