/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.stack;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract Item getItem();

    @Inject(method={"getMaxStackSize"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetMaxStackSize(CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue()) {
            return;
        }
        int configMax = (Integer)CoolConfig.maxStackSize.get();
        if (configMax > 0) {
            int vanillaMax = (Integer)this.getItem().components().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64);
            cir.setReturnValue((Object)Math.min(configMax, vanillaMax));
        }
    }

    @Inject(method={"isStackable"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsStackable(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue()) {
            return;
        }
        int configMax = (Integer)CoolConfig.maxStackSize.get();
        if (configMax == 0) {
            cir.setReturnValue((Object)((Integer)this.getItem().components().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64) > 1 ? 1 : 0));
        }
    }
}

