/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.TickHelper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public final class EntityTickHelper {
    private static final AtomicReference<Set<EntityType<?>>> WHITE_LIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<EntityType<?>>> BLACK_LIST = new AtomicReference(Collections.emptySet());
    private static final List<WildcardPattern> WHITE_PATTERNS = new ArrayList<WildcardPattern>();
    private static final List<WildcardPattern> BLACK_PATTERNS = new ArrayList<WildcardPattern>();
    private static volatile boolean enabled = true;
    private static volatile boolean tickRaidersInRaid = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;
    private static final boolean ignoreDeadEntities = true;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            EntityTickHelper.reloadConfig();
        }
    }

    public static boolean shouldSkipTick(Entity entity) {
        if (!enabled) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!living.m_6084_()) {
            return false;
        }
        if (!living.m_6084_()) {
            return true;
        }
        EntityType type = entity.m_6095_();
        if (EntityTickHelper.matchesWildcard(type, BLACK_PATTERNS) || BLACK_LIST.get().contains(type)) {
            return true;
        }
        if (EntityTickHelper.matchesWildcard(type, WHITE_PATTERNS) || WHITE_LIST.get().contains(type)) {
            return false;
        }
        if (tickRaidersInRaid && EntityTickHelper.isRaiderInRaid(living)) {
            return false;
        }
        return !EntityTickHelper.isNearPlayer(living);
    }

    private static void reloadConfig() {
        enabled = (Boolean)CoolConfig.optimizeEntities.get();
        tickRaidersInRaid = (Boolean)CoolConfig.tickRaidersInRaid.get();
        horizontalRange = (Integer)CoolConfig.horizontalRange.get();
        verticalRange = (Integer)CoolConfig.verticalRange.get();
        List whiteRaw = (List)CoolConfig.entityWhitelist.get();
        HashSet whiteIds = Sets.newHashSet();
        WHITE_PATTERNS.clear();
        BLACK_PATTERNS.clear();
        whiteRaw.forEach(s -> EntityTickHelper.parseEntry(s, whiteIds));
        WHITE_LIST.set((Set<EntityType<?>>)ImmutableSet.copyOf((Collection)whiteIds));
    }

    private static void parseEntry(String raw, Set<EntityType<?>> idTarget) {
        if (raw.contains("*") || raw.contains("?")) {
            WHITE_PATTERNS.add(new WildcardPattern(raw));
        } else {
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(raw));
            if (type != null) {
                idTarget.add(type);
            }
        }
    }

    private static boolean matchesWildcard(EntityType<?> type, List<WildcardPattern> list) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(type);
        if (id == null) {
            return false;
        }
        String str = id.toString();
        for (WildcardPattern p : list) {
            if (!p.matches(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRaiderInRaid(LivingEntity e) {
        Raider raider;
        return e instanceof Raider && (raider = (Raider)e).m_6084_() && raider.m_37886_();
    }

    private static boolean isNearPlayer(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel sl = (ServerLevel)level;
        BlockPos pos = entity.m_20183_();
        int cx = pos.m_123341_() >> 4;
        int cz = pos.m_123343_() >> 4;
        int radius = (horizontalRange >> 4) + 1;
        AABB box = new AABB((double)(pos.m_123341_() - horizontalRange), (double)(pos.m_123342_() - verticalRange), (double)(pos.m_123343_() - horizontalRange), (double)(pos.m_123341_() + horizontalRange), (double)(pos.m_123342_() + verticalRange), (double)(pos.m_123343_() + horizontalRange));
        for (Player player : sl.m_6907_()) {
            if (!player.m_6084_()) continue;
            BlockPos ppos = player.m_20183_();
            int pcx = ppos.m_123341_() >> 4;
            int pcz = ppos.m_123343_() >> 4;
            if (Math.abs(pcx - cx) > radius || Math.abs(pcz - cz) > radius || !player.m_20191_().m_82381_(box)) continue;
            return true;
        }
        return false;
    }

    static {
        EntityTickHelper.reloadConfig();
    }

    private static final class WildcardPattern {
        private final Pattern regex;

        WildcardPattern(String raw) {
            String s = raw.replace("?", ".{1}").replace("*", ".*");
            this.regex = Pattern.compile("^" + s + "$");
        }

        boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }
    }
}

