/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.client;

import java.util.List;
import net.carbonmc.graphene.TickHelper.EntityTickHelper;
import net.carbonmc.graphene.client.ClientEventHandler;
import net.carbonmc.graphene.client.ItemCountRenderer;
import net.carbonmc.graphene.client.gui.ClothConfigScreenFactory;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.AABBCullingManager;
import net.carbonmc.graphene.engine.cull.CullCache;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class GrapheneClient {
    public static GrapheneClient instance;
    private final CullCache cache = new CullCache();
    private final AABBCullingManager aabbCulling = new AABBCullingManager();
    private static final double CAMERA_UPDATE_THRESHOLD_SQ = 1.0;
    private Vec3 lastCameraPos = Vec3.f_82478_;
    private int framesSinceLastUpdate = 0;

    public GrapheneClient() {
        instance = this;
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ItemCountRenderer.class);
        MinecraftForge.EVENT_BUS.register(EntityTickHelper.class);
        MinecraftForge.EVENT_BUS.register(ClientEventHandler.class);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> ClothConfigScreenFactory.create(parent)));
    }

    public boolean shouldSkipEntity(Entity e) {
        if (e == null) {
            return false;
        }
        if (!CoolConfig.isEntityCullingEnabled()) {
            return false;
        }
        if (this.isEntityBlacklisted(e)) {
            return false;
        }
        this.updateCameraPosition();
        return this.aabbCulling.shouldCullEntity(e);
    }

    public boolean shouldSkipBlockEntity(BlockEntity be) {
        if (be == null) {
            return false;
        }
        if (!CoolConfig.isBlockEntityCullingEnabled()) {
            return false;
        }
        this.updateCameraPosition();
        return this.aabbCulling.shouldCullBlockEntity(be);
    }

    public CullCache getCullCache() {
        return this.cache;
    }

    public AABBCullingManager getAABBCullingManager() {
        return this.aabbCulling;
    }

    private boolean isEntityBlacklisted(Entity entity) {
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        String entityName = entityId.toString();
        List<? extends String> blacklist = CoolConfig.getEntityBlacklist();
        for (String string : blacklist) {
            if (!this.matchesPattern(entityName, string)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(String entityName, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.endsWith(":*")) {
            String namespace = pattern.substring(0, pattern.length() - 2);
            return entityName.startsWith(namespace + ":");
        }
        return entityName.equals(pattern);
    }

    private void updateCameraPosition() {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 currentCameraPos = mc.f_91063_.m_109153_().m_90583_();
        ++this.framesSinceLastUpdate;
        if (this.framesSinceLastUpdate >= 5 || currentCameraPos.m_82557_(this.lastCameraPos) > 4.0) {
            this.lastCameraPos = currentCameraPos;
            this.aabbCulling.updateCameraPosition();
            this.framesSinceLastUpdate = 0;
        }
    }

    public static void shutdown() {
        if (instance != null) {
            GrapheneClient.instance.aabbCulling.dispose();
            GrapheneClient.instance.cache.clear();
        }
    }
}

