/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.carbonmc.graphene.engine.cull.LeafOptiEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class RenderOptimizer {
    private static final AtomicBoolean FALLBACK_MODE = new AtomicBoolean(false);
    private static ExecutorService tracerPool;
    private static final int traceDistance = 16;
    private static ScheduledExecutorService timeoutChecker;
    private static final Cache<Long, Boolean> BLOCK_CACHE;

    public static boolean shouldCullBlockFace(BlockGetter level, BlockPos pos, Direction face) {
        if (FALLBACK_MODE.get()) {
            return LeafOptiEngine.checkSimpleConnection(level, pos.m_121945_(face), face);
        }
        Vec3 start = RenderOptimizer.getFaceCenter(pos, face);
        Vec3 end = start.m_82549_(new Vec3((double)(face.m_122429_() * 16), (double)(face.m_122430_() * 16), (double)(face.m_122431_() * 16)));
        long posKey = pos.m_121878_();
        Boolean cached = (Boolean)BLOCK_CACHE.getIfPresent((Object)posKey);
        if (cached != null) {
            return cached;
        }
        try {
            boolean result = ((CompletableFuture)RenderOptimizer.traceAsync(start, end, level).exceptionally(e -> {
                FALLBACK_MODE.set(true);
                return LeafOptiEngine.checkSimpleConnection(level, pos.m_121945_(face));
            })).getNow(false);
            BLOCK_CACHE.put((Object)posKey, (Object)result);
            return result;
        }
        catch (Exception e2) {
            FALLBACK_MODE.set(true);
            return LeafOptiEngine.checkSimpleConnection(level, pos.m_121945_(face), face);
        }
    }

    private static CompletableFuture<Boolean> traceAsync(Vec3 start, Vec3 end, BlockGetter level) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Future<?> task = tracerPool.submit(() -> {
            try {
                if (Thread.interrupted()) {
                    return;
                }
                future.complete(RenderOptimizer.traceVisibility(start, end, level));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        timeoutChecker.schedule(() -> {
            if (!future.isDone()) {
                task.cancel(true);
                future.complete(false);
            }
        }, 1L, TimeUnit.MINUTES);
        return future;
    }

    private static boolean traceVisibility(Vec3 start, Vec3 end, BlockGetter level) {
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        if (distance < 0.001) {
            return true;
        }
        direction = direction.m_82541_();
        double stepSize = Math.min(0.5, distance / 8.0);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Vec3 current = start;
        while (current.m_82554_(start) < distance) {
            if (Thread.interrupted()) {
                return false;
            }
            mpos.m_122169_(current.f_82479_, current.f_82480_, current.f_82481_);
            BlockState state = level.m_8055_((BlockPos)mpos);
            if (!state.m_60795_() && state.m_60812_(level, (BlockPos)mpos).m_83215_().m_82338_((BlockPos)mpos).m_82390_(current)) {
                return false;
            }
            current = current.m_82549_(direction.m_82490_(stepSize));
        }
        return true;
    }

    private static Vec3 getFaceCenter(BlockPos pos, Direction face) {
        return new Vec3((double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.501, (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.501, (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.501);
    }

    public static boolean isInFallbackMode() {
        return FALLBACK_MODE.get();
    }

    static {
        BLOCK_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.SECONDS).build();
    }
}

