/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.carbonmc.graphene.Graphene;
import net.carbonmc.graphene.opencl.OpenCLManager;
import net.carbonmc.graphene.opencl.VertexBufferTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BufferBuilder.class})
public class BufferBuilderMixin {
    @Shadow
    private ByteBuffer buffer;
    @Shadow
    private int vertices;
    @Shadow
    private VertexFormat format;

    @Inject(method={"end"}, at={@At(value="HEAD")})
    private void onEnd(CallbackInfoReturnable<BufferBuilder.RenderedBuffer> cir) {
        if (this.buffer != null && this.vertices > 0) {
            VertexBufferTracker.trackCurrentBuffer((BufferBuilder)((BufferBuilder)this), (ByteBuffer)this.buffer, (int)this.vertices, (VertexFormat)this.format);
            this.processVertexTransformation();
        }
    }

    private void processVertexTransformation() {
        OpenCLManager openCL = Graphene.INSTANCE.getOpenCLManager();
        if (openCL == null || !openCL.isInitialized()) {
            return;
        }
        VertexBufferTracker.RenderContext context = VertexBufferTracker.getCurrentContext();
        if (!context.isValid()) {
            return;
        }
        openCL.transformVertices(context.getPositionBuffer(), context.currentVertexCount, context.modelViewMatrix, context.projectionMatrix);
        VertexBufferTracker.clearContext();
    }
}

