/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.client.renderer.culling;

import com.mojang.blaze3d.vertex.PoseStack;
import net.carbonmc.graphene.accessor.EntityRendererAccessor;
import net.carbonmc.graphene.client.GrapheneClient;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.iface.EntityVisibility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Final
    @Shadow
    private EntityRenderDispatcher f_109463_;
    @Unique
    private final Minecraft graphene$mc = Minecraft.m_91087_();

    @Inject(method={"renderEntity"}, at={@At(value="TAIL")}, cancellable=true)
    private void graphene$skipCulledEntityButMaybeRenderNameTag(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers, CallbackInfo ci) {
        if (!CoolConfig.isCullingEnabled()) {
            return;
        }
        GrapheneClient client = GrapheneClient.instance;
        if (client == null || !(entity instanceof EntityVisibility)) {
            return;
        }
        EntityVisibility cullable = (EntityVisibility)entity;
        if (cullable.graphene$isForcedVisible() || entity.f_19811_) {
            cullable.graphene$setOutOfCamera(false);
            return;
        }
        if (client.shouldSkipEntity(entity)) {
            if (!CoolConfig.isNameTagCullingEnabled() && matrices != null && consumers != null && this.graphene$shouldRenderNameTag(entity)) {
                this.graphene$renderNameTag(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, consumers);
            }
            ci.cancel();
            return;
        }
        cullable.graphene$setOutOfCamera(false);
    }

    @Unique
    private boolean graphene$shouldRenderNameTag(Entity entity) {
        EntityRendererAccessor accessor;
        EntityRenderer renderer = this.f_109463_.m_114382_(entity);
        return renderer instanceof EntityRendererAccessor && (accessor = (EntityRendererAccessor)renderer).graphene_shouldShowName(entity);
    }

    @Unique
    private void graphene$renderNameTag(Entity entity, double camX, double camY, double camZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers) {
        EntityRenderer renderer = this.f_109463_.m_114382_(entity);
        if (!(renderer instanceof EntityRendererAccessor)) {
            return;
        }
        EntityRendererAccessor accessor = (EntityRendererAccessor)renderer;
        double x = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_()) - camX;
        double y = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_()) - camY;
        double z = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_()) - camZ;
        Vec3 offset = renderer.m_7860_(entity, tickDelta);
        matrices.m_85836_();
        matrices.m_85837_(x + offset.f_82479_, y + offset.f_82480_, z + offset.f_82481_);
        accessor.graphene_renderNameTag(entity, entity.m_5446_(), matrices, consumers, this.f_109463_.m_114394_(entity, tickDelta));
        matrices.m_85849_();
    }
}

