/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.stack;

import java.util.Comparator;
import java.util.List;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    private static final int MERGE_COOLDOWN_TICKS = 5;
    private static final int DEFAULT_MAX_STACK = 2147483547;
    @Unique
    private int lastMergeTick = -1;

    @Shadow
    public abstract ItemStack m_32055_();

    @Shadow
    public abstract void m_32045_(ItemStack var1);

    @Shadow
    public abstract void m_32064_();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.updateStackDisplay(self);
        if (this.shouldAttemptMerge(self)) {
            this.lastMergeTick = (int)self.m_9236_().m_46467_();
            this.tryMergeItems(self);
        }
    }

    @Unique
    private boolean shouldProcess() {
        return (Boolean)CoolConfig.OpenIO.get() != false && !((ItemEntity)this).m_9236_().f_46443_;
    }

    @Unique
    private boolean shouldAttemptMerge(ItemEntity self) {
        long gameTime = self.m_9236_().m_46467_();
        return this.lastMergeTick == -1 || gameTime - (long)this.lastMergeTick >= 5L;
    }

    @Unique
    private void tryMergeItems(ItemEntity self) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue()) {
            return;
        }
        ItemStack stack = self.m_32055_();
        int maxStack = this.getEffectiveMaxStackSize();
        if (stack.m_41613_() >= maxStack) {
            return;
        }
        List<ItemEntity> nearby = this.findMergeableItems(self);
        if (nearby.isEmpty()) {
            return;
        }
        this.performMerge(self, stack, maxStack, nearby);
    }

    @Unique
    private int getEffectiveMaxStackSize() {
        int configMax = (Integer)CoolConfig.maxStackSize.get();
        return configMax > 0 ? configMax : 2147483547;
    }

    @Unique
    private List<ItemEntity> findMergeableItems(ItemEntity self) {
        double mergeDistance = (Double)CoolConfig.mergeDistance.get();
        int listMode = (Integer)CoolConfig.listMode.get();
        List itemList = (List)CoolConfig.itemList.get();
        ItemStack selfStack = self.m_32055_();
        List nearby = self.m_9236_().m_6443_(ItemEntity.class, self.m_20191_().m_82400_(mergeDistance), e -> this.isValidMergeTarget(self, (ItemEntity)e, listMode, itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((ItemEntity)self).m_20280_(arg_0)));
        return nearby;
    }

    @Unique
    private void performMerge(ItemEntity self, ItemStack stack, int maxStack, List<ItemEntity> nearby) {
        int remainingSpace = maxStack - stack.m_41613_();
        for (ItemEntity other : nearby) {
            if (remainingSpace <= 0) break;
            ItemStack otherStack = other.m_32055_();
            int transfer = Math.min(otherStack.m_41613_(), remainingSpace);
            stack.m_41769_(transfer);
            self.m_32045_(stack);
            self.m_32064_();
            this.handleOtherStackAfterTransfer(other, otherStack, transfer);
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void handleOtherStackAfterTransfer(ItemEntity other, ItemStack otherStack, int transfer) {
        if (otherStack.m_41613_() == transfer) {
            other.m_146870_();
        } else {
            otherStack.m_41774_(transfer);
            other.m_32045_(otherStack);
            this.updateStackDisplay(other);
        }
    }

    @Unique
    private void updateStackDisplay(ItemEntity entity) {
        if (!((Boolean)CoolConfig.OpenIO.get()).booleanValue() || !((Boolean)CoolConfig.showStackCount.get()).booleanValue()) {
            this.clearDisplay(entity);
            return;
        }
        ItemStack stack = entity.m_32055_();
        if (stack.m_41613_() > 1) {
            this.setStackCountDisplay(entity, stack.m_41613_());
        } else {
            this.clearDisplay(entity);
        }
    }

    @Unique
    private void setStackCountDisplay(ItemEntity entity, int count) {
        MutableComponent countText = Component.m_237113_((String)("\u00d7" + count)).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.BOLD);
        entity.m_6593_((Component)countText);
        entity.m_20340_(true);
    }

    @Unique
    private void clearDisplay(ItemEntity entity) {
        entity.m_6593_(null);
        entity.m_20340_(false);
    }

    @Unique
    private boolean isValidMergeTarget(ItemEntity self, ItemEntity other, int listMode, List<? extends String> itemList) {
        ItemStack otherStack;
        if (self == other || other.m_213877_()) {
            return false;
        }
        ItemStack selfStack = self.m_32055_();
        return this.isSameItem(selfStack, otherStack = other.m_32055_()) && this.isMergeAllowed(otherStack, listMode, itemList) && ((Boolean)CoolConfig.lockMaxedStacks.get() == false || otherStack.m_41613_() < this.getEffectiveMaxStackSize());
    }

    @Unique
    private boolean isSameItem(ItemStack a, ItemStack b) {
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    @Unique
    private boolean isMergeAllowed(ItemStack stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (id == null) {
            return false;
        }
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 ? inList : !inList;
    }
}

