/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.chunk;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.carbonmc.graphene.async.chunk.Executor;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.GlobalExecutorManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkPool
implements AutoCloseable {
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private static final long SHUTDOWN_TIMEOUT_MS = 5000L;
    private static final Logger LOGGER = LogManager.getLogger();
    public volatile ExecutorService p;
    public volatile ExecutorService q;
    private volatile int cpuThreads = -1;
    private volatile int ioThreads = -1;
    private volatile long lastRebuildTime = 0L;
    private final String instanceId;
    private volatile boolean shuttingDown = false;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    public ChunkPool() {
        this.instanceId = "ChunkPool-" + INSTANCE_COUNT.incrementAndGet();
        if (((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            this.a();
            GlobalExecutorManager.registerResource(this);
        }
    }

    private int calculateOptimalCpuThreads() {
        int configuredThreads = (Integer)CoolConfig.CHUNKIO_THREADS.get();
        if (configuredThreads > 0) {
            return Math.max(2, configuredThreads);
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (availableProcessors <= 4) {
            return Math.max(2, availableProcessors - 1);
        }
        if (availableProcessors <= 8) {
            return availableProcessors - 2;
        }
        return Math.max(4, availableProcessors / 2);
    }

    private int calculateOptimalIoThreads(int cpuThreadCount) {
        int configuredIoThreads = (Integer)CoolConfig.CHUNKIO_THREADS.get();
        if (configuredIoThreads > 0) {
            return configuredIoThreads;
        }
        return Math.max(2, Math.min(cpuThreadCount, Runtime.getRuntime().availableProcessors() > 8 ? 6 : 4));
    }

    private int getCpuQueueSize() {
        return Math.max(256, (Integer)CoolConfig.CPU_QUEUE.get());
    }

    private int getIoQueueSize() {
        return Math.max(128, (Integer)CoolConfig.IO_QUEUE.get());
    }

    public synchronized void a() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue() || this.shuttingDown) {
            return;
        }
        if (this.shouldRebuildExecutors()) {
            int desiredCpuThreads = this.calculateOptimalCpuThreads();
            int desiredIoThreads = this.calculateOptimalIoThreads(desiredCpuThreads);
            ChunkPool.shutdownExecutor(this.p);
            ChunkPool.shutdownExecutor(this.q);
            this.p = this.createOptimizedCpuExecutor(desiredCpuThreads, this.getCpuQueueSize());
            this.q = this.createOptimizedIoExecutor(desiredIoThreads, this.getIoQueueSize());
            this.cpuThreads = desiredCpuThreads;
            this.ioThreads = desiredIoThreads;
            this.lastRebuildTime = System.currentTimeMillis();
        }
    }

    public synchronized void v() {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue() || this.shuttingDown) {
            return;
        }
        this.cpuThreads = -1;
        this.ioThreads = -1;
        this.a();
    }

    private boolean shouldRebuildExecutors() {
        if (this.p == null || this.p.isShutdown() || this.q == null || this.q.isShutdown()) {
            return true;
        }
        int desiredCpuThreads = this.calculateOptimalCpuThreads();
        int desiredIoThreads = this.calculateOptimalIoThreads(desiredCpuThreads);
        return this.cpuThreads != desiredCpuThreads || this.ioThreads != desiredIoThreads;
    }

    private static void shutdownExecutor(ExecutorService executor) {
        if (executor == null) {
            return;
        }
        try {
            executor.shutdown();
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public <T> CompletableFuture<T> ad(Supplier<T> taskSupplier) {
        if (this.shuttingDown || !((Boolean)CoolConfig.CTU.get()).booleanValue() || GlobalExecutorManager.isShuttingDown()) {
            return CompletableFuture.failedFuture(new RejectedExecutionException("ChunkPool is shutting down or disabled"));
        }
        this.a();
        return CompletableFuture.supplyAsync(taskSupplier, this.p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownGracefully() {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        GlobalExecutorManager.unregisterResource(this);
        try {
            List<Runnable> remaining;
            if (this.p != null) {
                this.p.shutdown();
            }
            if (this.q != null) {
                this.q.shutdown();
            }
            boolean pTerminated = false;
            boolean qTerminated = false;
            if (this.p != null) {
                pTerminated = this.p.awaitTermination(2500L, TimeUnit.MILLISECONDS);
            }
            if (this.q != null) {
                qTerminated = this.q.awaitTermination(2500L, TimeUnit.MILLISECONDS);
            }
            if (!pTerminated && this.p != null && !(remaining = this.p.shutdownNow()).isEmpty()) {
                LOGGER.debug("Force shutdown {} CPU tasks in {}", (Object)remaining.size(), (Object)this.instanceId);
            }
            if (!qTerminated && this.q != null && !(remaining = this.q.shutdownNow()).isEmpty()) {
                LOGGER.debug("Force shutdown {} IO tasks in {}", (Object)remaining.size(), (Object)this.instanceId);
            }
            if (this.p != null) {
                this.p.awaitTermination(2500L, TimeUnit.MILLISECONDS);
            }
            if (this.q != null) {
                this.q.awaitTermination(2500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.forceShutdown();
        }
        finally {
            this.p = null;
            this.q = null;
            this.cpuThreads = -1;
            this.ioThreads = -1;
            this.shutdownLatch.countDown();
        }
    }

    private void forceShutdown() {
        if (this.p != null) {
            this.p.shutdownNow();
        }
        if (this.q != null) {
            this.q.shutdownNow();
        }
    }

    public void awaitShutdown() throws InterruptedException {
        this.shutdownLatch.await(5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.shutdownGracefully();
    }

    @Deprecated
    public void af() {
        this.shutdownGracefully();
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public boolean isTerminated() {
        return !(this.p != null && !this.p.isTerminated() || this.q != null && !this.q.isTerminated());
    }

    private ExecutorService createOptimizedCpuExecutor(int threads, int queueSize) {
        return new Executor(threads, queueSize, "Graphene-CPU-" + this.instanceId);
    }

    private ExecutorService createOptimizedIoExecutor(int threads, int queueSize) {
        return new Executor(threads, queueSize, "Graphene-IO-" + this.instanceId);
    }

    public int getCpuThreadCount() {
        return this.cpuThreads;
    }

    public int getIoThreadCount() {
        return this.ioThreads;
    }

    public long getLastRebuildTime() {
        return this.lastRebuildTime;
    }

    public boolean isHealthy() {
        return this.p != null && !this.p.isShutdown() && this.q != null && !this.q.isShutdown() && !this.shuttingDown;
    }
}

