/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.async.resources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import net.carbonmc.graphene.async.AsyncSystemInitializer;
import net.carbonmc.graphene.event.AsyncHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@AsyncHandler(threadPool="io", fallbackToSync=false)
public class AsyncResourceLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockingQueue<ResourceTask> resourceQueue = new LinkedBlockingQueue<ResourceTask>(100);
    private static final ConcurrentLinkedQueue<ResourceTask> completedTasks = new ConcurrentLinkedQueue();
    private static final int MAX_LOAD_ATTEMPTS = 3;
    private static final Semaphore loadSemaphore = new Semaphore(20);

    public static void init() {
        LOGGER.info("Async Resource Loader initialized");
    }

    public static void shutdown() {
        resourceQueue.clear();
        completedTasks.clear();
        LOGGER.info("Async Resource Loader shutdown completed");
    }

    public static CompletableFuture<Void> loadResourcePackAsync(PackRepository repository, Path packPath) {
        if (repository == null || packPath == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid parameters"));
        }
        if (!loadSemaphore.tryAcquire()) {
            LOGGER.warn("Too many concurrent resource loads, skipping {}", (Object)packPath);
            return CompletableFuture.failedFuture(new IllegalStateException("Too many concurrent loads"));
        }
        ResourceTask task = new ResourceTask(repository, packPath);
        if (!resourceQueue.offer(task)) {
            loadSemaphore.release();
            LOGGER.warn("Resource queue full, skipping {}", (Object)packPath);
            return CompletableFuture.failedFuture(new IllegalStateException("Resource queue full"));
        }
        return task.future().whenComplete((r, e) -> loadSemaphore.release());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AsyncResourceLoader.processCompletedTasks();
            AsyncResourceLoader.processNewTasks();
        }
    }

    private static void processCompletedTasks() {
        ResourceTask completedTask;
        while ((completedTask = completedTasks.poll()) != null) {
            try {
                if (completedTask.error().get() == null) {
                    PackResources resources = completedTask.resources().get();
                    if (resources == null) continue;
                    AsyncResourceLoader.registerResourcePack(completedTask.repository(), completedTask.packPath(), resources);
                    continue;
                }
                completedTask.future().completeExceptionally(completedTask.error().get());
            }
            catch (Exception e) {
                LOGGER.error("Error processing completed resource task", (Throwable)e);
                completedTask.future().completeExceptionally(e);
            }
        }
    }

    private static void processNewTasks() {
        ResourceTask task;
        while ((task = (ResourceTask)resourceQueue.poll()) != null) {
            ResourceTask finalTask = task;
            AsyncSystemInitializer.getThreadPool("io").execute(() -> {
                try {
                    PackResources resources = AsyncResourceLoader.loadWithRetry(finalTask.packPath());
                    finalTask.resources().set(resources);
                    completedTasks.add(finalTask);
                    finalTask.future().complete(null);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load resource pack: {}", (Object)finalTask.packPath(), (Object)e);
                    finalTask.error().set(e);
                    completedTasks.add(finalTask);
                    finalTask.future().completeExceptionally(e);
                }
            });
        }
    }

    private static PackResources loadWithRetry(Path packPath) throws IOException {
        IOException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return AsyncResourceLoader.loadPackResources(packPath);
            }
            catch (IOException e) {
                lastException = e;
                if (i >= 2) continue;
                try {
                    Thread.sleep(100 * (i + 1));
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted during retry", ie);
                }
            }
        }
        throw lastException;
    }

    private static void registerResourcePack(PackRepository repository, Path packPath, PackResources resources) {
        try {
            String packName = packPath.getFileName().toString();
            Pack pack = Pack.m_245429_((String)packName, (Component)Component.m_237113_((String)packName), (boolean)true, name -> resources, (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            if (pack != null) {
                ArrayList<String> selectedIds = new ArrayList<String>();
                for (Pack existing : repository.m_10524_()) {
                    selectedIds.add(existing.m_10446_());
                }
                selectedIds.add(pack.m_10446_());
                repository.m_10509_(selectedIds);
                repository.m_10506_();
                LOGGER.info("Successfully loaded resource pack: {}", (Object)packName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register resource pack: " + String.valueOf(packPath), e);
        }
    }

    private static PackResources loadPackResources(Path packPath) throws IOException {
        if (!Files.exists(packPath, new LinkOption[0])) {
            throw new IOException("Resource pack not found: " + String.valueOf(packPath));
        }
        return new PathPackResources(packPath.getFileName().toString(), packPath, false);
    }

    private static class ResourceTask {
        private final PackRepository repository;
        private final Path packPath;
        private final AtomicReference<PackResources> resources = new AtomicReference();
        private final AtomicReference<Exception> error = new AtomicReference();
        private final CompletableFuture<Void> future = new CompletableFuture();

        public ResourceTask(PackRepository repository, Path packPath) {
            this.repository = repository;
            this.packPath = packPath;
        }

        public PackRepository repository() {
            return this.repository;
        }

        public Path packPath() {
            return this.packPath;
        }

        public AtomicReference<PackResources> resources() {
            return this.resources;
        }

        public AtomicReference<Exception> error() {
            return this.error;
        }

        public CompletableFuture<Void> future() {
            return this.future;
        }
    }
}

