/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.event;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.Graphene;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.event.AsyncEventSystem;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.Type;

public class ModEventProcessor {
    private static final Type SUBSCRIBE_EVENT = Type.getType(SubscribeEvent.class);
    private static final String CLIENT_ONLY_WARNING = "Skipping client-side class loading on server: ";
    private static final Cache<String, Boolean> CLASS_BLACKLIST_CACHE = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Boolean> MOD_BLACKLIST_CACHE = Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Cache<String, Boolean> PROCESSED_CLASSES = Caffeine.newBuilder().maximumSize(5000L).expireAfterWrite(6L, TimeUnit.HOURS).build();

    public static void initialize() {
        block2: {
            try {
                ModEventProcessor.loadBlacklists();
            }
            catch (Exception e) {
                if (!((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) break block2;
                ModEventProcessor.logError("Failed to initialize ModEventProcessor", e);
            }
        }
    }

    public static void processModEvents() {
        if (!FMLEnvironment.dist.isClient()) {
            if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                AsyncEventSystem.LOGGER.info("Server environment detected - skipping client event processing");
            }
            return;
        }
        try {
            List allScanData = ModList.get().getAllScanData();
            HashSet<String> eventMethods = new HashSet<String>();
            for (ModFileScanData scanData : allScanData) {
                ModEventProcessor.processScanData(scanData, eventMethods);
            }
            if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                AsyncEventSystem.LOGGER.info("Found {} event methods in mods", (Object)eventMethods.size());
            }
            ModEventProcessor.processEventMethods(eventMethods);
        }
        catch (Exception e) {
            ModEventProcessor.logError("Critical error in processModEvents", e);
        }
    }

    private static void processScanData(ModFileScanData scanData, Set<String> eventMethods) {
        String modId = ModEventProcessor.getModIdFromScanData(scanData);
        if (modId == null || MOD_BLACKLIST_CACHE.getIfPresent((Object)modId) != null) {
            if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                AsyncEventSystem.LOGGER.debug("Skipping blacklisted or invalid mod: {}", (Object)modId);
            }
            return;
        }
        for (ModFileScanData.AnnotationData ad : scanData.getAnnotations()) {
            if (!SUBSCRIBE_EVENT.equals((Object)ad.annotationType())) continue;
            ModEventProcessor.processAnnotationData(ad, eventMethods);
        }
    }

    private static String getModIdFromScanData(ModFileScanData scanData) {
        block4: {
            try {
                if (!scanData.getIModInfoData().isEmpty()) {
                    return ((IModInfo)((IModFileInfo)scanData.getIModInfoData().get(0)).getMods().get(0)).getModId();
                }
                if (scanData.getTargets() != null && !scanData.getTargets().isEmpty()) {
                    return (String)scanData.getTargets().keySet().iterator().next();
                }
            }
            catch (Exception e) {
                if (!((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) break block4;
                ModEventProcessor.logError("Failed to get modId from scan data", e);
            }
        }
        return null;
    }

    private static void processAnnotationData(ModFileScanData.AnnotationData ad, Set<String> eventMethods) {
        try {
            String className = ad.clazz().getClassName();
            if (PROCESSED_CLASSES.getIfPresent((Object)className) != null) {
                return;
            }
            if (ModEventProcessor.isBlacklisted(className)) {
                if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                    AsyncEventSystem.LOGGER.debug("Skipping blacklisted class: {}", (Object)className);
                }
                PROCESSED_CLASSES.put((Object)className, (Object)true);
                return;
            }
            if (ModEventProcessor.isClientOnlyClass(className)) {
                AsyncEventSystem.LOGGER.debug(CLIENT_ONLY_WARNING + className);
                PROCESSED_CLASSES.put((Object)className, (Object)true);
                return;
            }
            if (CoolConfig.isStrictClassCheckingEnabled()) {
                try {
                    Class.forName(className, false, ModEventProcessor.class.getClassLoader());
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    if (((Boolean)CoolConfig.DEBUG_LOGGING.get()).booleanValue()) {
                        AsyncEventSystem.LOGGER.debug("Class loading failed: {}", (Object)className);
                    }
                    PROCESSED_CLASSES.put((Object)className, (Object)true);
                    return;
                }
            }
            eventMethods.add(className + "#" + ad.memberName());
            PROCESSED_CLASSES.put((Object)className, (Object)true);
        }
        catch (Exception e) {
            ModEventProcessor.logError("Failed to process annotation data", e);
        }
    }

    private static void processEventMethods(Set<String> eventMethods) {
        for (String methodInfo : eventMethods) {
            try {
                String[] parts = methodInfo.split("#");
                if (parts.length != 2) continue;
                String className = parts[0];
                String methodName = parts[1];
                if (ModEventProcessor.isClientOnlyClass(className)) {
                    AsyncEventSystem.LOGGER.warn(CLIENT_ONLY_WARNING + className);
                    continue;
                }
                Class<?> clazz = Class.forName(className);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    ModEventProcessor.processMethod(method);
                }
            }
            catch (NoClassDefFoundError e) {
                ModEventProcessor.handleClassLoadingError(e);
            }
            catch (Exception e) {
                ModEventProcessor.logError("Failed to process event method " + methodInfo, e);
            }
        }
    }

    private static void processMethod(Method method) {
        Class<?> eventType;
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1 && Event.class.isAssignableFrom(params[0]) && !ModEventProcessor.isBlacklisted((eventType = params[0]).getName())) {
            AsyncEventSystem.registerAsyncEvent(eventType);
            AsyncEventSystem.LOGGER.debug("Registered async event: {}", (Object)eventType.getName());
        }
    }

    public static void loadBlacklists() {
        try {
            CLASS_BLACKLIST_CACHE.invalidateAll();
            MOD_BLACKLIST_CACHE.invalidateAll();
            CoolConfig.getAsyncEventClassBlacklist().forEach(cls -> CLASS_BLACKLIST_CACHE.put(cls, (Object)true));
            CoolConfig.getAsyncEventModBlacklist().forEach(mod -> MOD_BLACKLIST_CACHE.put(mod, (Object)true));
            AsyncEventSystem.LOGGER.info("Loaded blacklists: {} classes, {} mods", (Object)CLASS_BLACKLIST_CACHE.estimatedSize(), (Object)MOD_BLACKLIST_CACHE.estimatedSize());
        }
        catch (Exception e) {
            ModEventProcessor.logError("Failed to load blacklists", e);
        }
    }

    private static boolean isBlacklisted(String className) {
        if (CLASS_BLACKLIST_CACHE.getIfPresent((Object)className) != null) {
            return true;
        }
        for (String pattern : CoolConfig.getAsyncEventClassBlacklist()) {
            if (!pattern.endsWith(".*") || !className.startsWith(pattern.substring(0, pattern.length() - 1))) continue;
            CLASS_BLACKLIST_CACHE.put((Object)className, (Object)true);
            return true;
        }
        return false;
    }

    private static boolean isClientOnlyClass(String className) {
        return className.startsWith("net.minecraft.client.") || className.contains(".client.") || className.endsWith("ClientEvents");
    }

    private static void handleClassLoadingError(NoClassDefFoundError e) {
        if (e.getMessage() != null && e.getMessage().contains("client/renderer")) {
            AsyncEventSystem.LOGGER.warn(CLIENT_ONLY_WARNING + e.getMessage());
        } else {
            ModEventProcessor.logError("Class loading failed", e);
        }
    }

    private static void logError(String message, Throwable e) {
        AsyncEventSystem.LOGGER.error(message, e);
        try {
            FileUtils.writeStringToFile((File)Graphene.Graphene_EVENTS_LOG, (String)("\n" + message + ": " + String.valueOf(e) + "\n"), (boolean)true);
            for (StackTraceElement ste : e.getStackTrace()) {
                FileUtils.writeStringToFile((File)Graphene.Graphene_EVENTS_LOG, (String)(ste.toString() + "\n"), (boolean)true);
            }
        }
        catch (IOException ioEx) {
            AsyncEventSystem.LOGGER.error("Failed to write to error log", (Throwable)ioEx);
        }
    }
}

