/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.mixin.server;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenRegion.class})
public abstract class MixinWorldGenRegion {
    @Shadow
    private List<ChunkAccess> f_9475_;
    @Shadow
    private int f_9478_;
    @Shadow
    private ChunkPos f_9487_;
    @Shadow
    private ChunkPos f_9488_;
    private Cache<Long, ChunkAccess> chunkCache;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.chunkCache = Caffeine.newBuilder().maximumSize(256L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    }

    @Overwrite
    public ChunkAccess m_6325_(int chunkX, int chunkZ) {
        long key = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
        ChunkAccess cachedChunk = (ChunkAccess)this.chunkCache.getIfPresent((Object)key);
        if (cachedChunk != null) {
            return cachedChunk;
        }
        if (chunkX < this.f_9487_.f_45578_ || chunkX > this.f_9488_.f_45578_ || chunkZ < this.f_9487_.f_45579_ || chunkZ > this.f_9488_.f_45579_) {
            throw new RuntimeException(String.format("We are asking MixinRandomA chunk for MixinRandomA chunk out of bound | %s %s", chunkX, chunkZ));
        }
        int index = chunkX - this.f_9487_.f_45578_ + (chunkZ - this.f_9487_.f_45579_) * this.f_9478_;
        ChunkAccess chunk = this.f_9475_.get(index);
        this.chunkCache.put((Object)key, (Object)chunk);
        return chunk;
    }

    @Overwrite
    public BlockState m_8055_(BlockPos pos) {
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        return this.m_6325_(chunkX, chunkZ).m_8055_(pos);
    }

    @Overwrite
    public FluidState m_6425_(BlockPos pos) {
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        return this.m_6325_(chunkX, chunkZ).m_6425_(pos);
    }
}

