/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.chunk;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.ChunkOptif;
import net.carbonmc.graphene.optimization.chunk.GlobalExecutorManager;
import org.jetbrains.annotations.NotNull;

public final class AES
extends AbstractExecutorService
implements AutoCloseable {
    private final Supplier<ExecutorService> executorProvider;
    private volatile boolean active = true;
    private final String name;
    private final AtomicInteger executedTasks = new AtomicInteger();
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private final int instanceId;
    private static final ConcurrentHashMap<String, ExecutorService> SHARED_EXECUTORS = new ConcurrentHashMap();
    private static final int MAX_SHARED_EXECUTORS = 4;

    public AES(Supplier<ExecutorService> executorProvider, String name) {
        this.executorProvider = executorProvider;
        this.name = name;
        this.instanceId = INSTANCE_COUNT.incrementAndGet();
        GlobalExecutorManager.registerResource(this);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue() || !this.active) {
            command.run();
            return;
        }
        this.executedTasks.incrementAndGet();
        Long currentRegionId = ChunkOptif.currentRegion();
        if (currentRegionId == null) {
            this.getOrCreateExecutor().execute(command);
        } else {
            this.getOrCreateExecutor().execute(() -> {
                try {
                    ChunkOptif.go(currentRegionId);
                    command.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    ChunkOptif.to();
                    ChunkOptif.cleanupThreadState();
                }
            });
        }
    }

    private ExecutorService getOrCreateExecutor() {
        String executorKey = "AES-Shared-" + this.instanceId % 4;
        return SHARED_EXECUTORS.computeIfAbsent(executorKey, k -> Executors.newWorkStealingPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 4)));
    }

    @Override
    public void shutdown() {
        this.active = false;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.active = false;
        ExecutorService executor = this.executorProvider.get();
        return executor != null ? executor.shutdownNow() : List.of();
    }

    @Override
    public boolean isShutdown() {
        return !this.active;
    }

    @Override
    public boolean isTerminated() {
        return !this.active;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        this.executedTasks.incrementAndGet();
        return this.getOrCreateExecutor().submit(task);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        this.executedTasks.incrementAndGet();
        return this.getOrCreateExecutor().submit(task, result);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        this.executedTasks.incrementAndGet();
        return this.getOrCreateExecutor().submit(task);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.executedTasks.addAndGet(tasks.size());
        return this.getOrCreateExecutor().invokeAll(tasks);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        this.executedTasks.addAndGet(tasks.size());
        return this.getOrCreateExecutor().invokeAll(tasks, timeout, unit);
    }

    public int getExecutedTaskCount() {
        return this.executedTasks.get();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
        GlobalExecutorManager.unregisterResource(this);
    }

    public static void cleanupSharedExecutors() {
        for (ExecutorService executor : SHARED_EXECUTORS.values()) {
            if (executor.isShutdown()) continue;
            executor.shutdown();
            try {
                if (executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                executor.shutdownNow();
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        SHARED_EXECUTORS.clear();
    }
}

