/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import net.carbonmc.graphene.async.chunk.ChunkPool;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.optimization.chunk.AES;
import net.carbonmc.graphene.optimization.chunk.RE;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GlobalExecutorManager {
    private static final List<AutoCloseable> RESOURCES = new ArrayList<AutoCloseable>();
    private static final long TOTAL_SHUTDOWN_TIMEOUT_MS = 10000L;
    private static final AtomicBoolean SHUTDOWN_IN_PROGRESS = new AtomicBoolean(false);
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResource(AutoCloseable resource) {
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue() || SHUTDOWN_IN_PROGRESS.get()) {
            return;
        }
        List<AutoCloseable> list = RESOURCES;
        synchronized (list) {
            RESOURCES.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResource(AutoCloseable resource) {
        List<AutoCloseable> list = RESOURCES;
        synchronized (list) {
            RESOURCES.remove(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        ArrayList<AutoCloseable> toShutdown;
        if (SHUTDOWN_IN_PROGRESS.getAndSet(true)) {
            return;
        }
        if (!((Boolean)CoolConfig.CTU.get()).booleanValue()) {
            return;
        }
        AES.cleanupSharedExecutors();
        RE.shutdown();
        List<AutoCloseable> list = RESOURCES;
        synchronized (list) {
            toShutdown = new ArrayList<AutoCloseable>(RESOURCES);
            RESOURCES.clear();
        }
        ArrayList<ChunkPool> chunkPools = new ArrayList<ChunkPool>();
        ArrayList<ExecutorService> executors = new ArrayList<ExecutorService>();
        ArrayList<AutoCloseable> others = new ArrayList<AutoCloseable>();
        for (AutoCloseable resource : toShutdown) {
            if (resource instanceof ChunkPool) {
                chunkPools.add((ChunkPool)resource);
                continue;
            }
            if (resource instanceof ExecutorService) {
                executors.add((ExecutorService)resource);
                continue;
            }
            others.add(resource);
        }
        long startTime = System.currentTimeMillis();
        for (ChunkPool pool : chunkPools) {
            if (pool.isShuttingDown()) continue;
            pool.shutdownGracefully();
        }
        for (ExecutorService executor : executors) {
            if (executor.isShutdown()) continue;
            executor.shutdown();
        }
        for (ChunkPool pool : chunkPools) {
            try {
                if (pool.isTerminated()) continue;
                pool.awaitShutdown();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        for (ExecutorService executor : executors) {
            List<Runnable> remaining;
            if (executor.isTerminated() || (remaining = executor.shutdownNow()).isEmpty()) continue;
            LOGGER.debug("Force shutdown {} tasks from {}", (Object)remaining.size(), (Object)executor);
        }
        for (AutoCloseable resource : others) {
            try {
                resource.close();
            }
            catch (Exception exception) {}
        }
        long duration = System.currentTimeMillis() - startTime;
        LOGGER.debug("Graphene shutdown completed in {}ms", (Object)duration);
    }

    public static void cleanupAESExecutors() {
        RE.shutdown();
    }

    public static boolean isShuttingDown() {
        return SHUTDOWN_IN_PROGRESS.get();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(GlobalExecutorManager::shutdownAll, "Graphene-Shutdown"));
    }
}

