/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization.event;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraftforge.eventbus.api.IEventListener;

public final class FastEventFactory {
    private static final ConcurrentMap<MethodKey, IEventListener> CACHE = new ConcurrentHashMap<MethodKey, IEventListener>();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private FastEventFactory() {
    }

    public static IEventListener createListener(Method method, Object instance) {
        MethodKey key = new MethodKey(method, instance);
        return CACHE.computeIfAbsent(key, k -> FastEventFactory.createLambdaListener(method, instance));
    }

    private static IEventListener createLambdaListener(Method method, Object instance) {
        try {
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            MethodHandle listenerFactory = FastEventFactory.createListenerFactory(LOOKUP, method, isStatic, instance);
            return (IEventListener)(isStatic ? listenerFactory.invokeExact() : listenerFactory.invokeExact(instance));
        }
        catch (Throwable t) {
            System.err.println("Failed to create lambda event listener for method: " + method.getName());
            t.printStackTrace();
            return event -> {};
        }
    }

    private static MethodHandle createListenerFactory(MethodHandles.Lookup lookup, Method callback, boolean isStatic, Object instance) throws Exception {
        MethodHandle handle = lookup.unreflect(callback);
        MethodType factoryType = isStatic ? MethodType.methodType(IEventListener.class) : MethodType.methodType(IEventListener.class, instance.getClass());
        MethodType targetMethodType = MethodType.methodType(Void.TYPE, handle.type().parameterType(isStatic ? 0 : 1));
        MethodHandle factoryHandle = LambdaMetafactory.metafactory(lookup, "invoke", factoryType, MethodType.methodType(Void.TYPE, Object.class), handle, targetMethodType).getTarget();
        return isStatic ? factoryHandle : factoryHandle.asType(factoryType.changeParameterType(0, Object.class));
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public static int getCacheSize() {
        return CACHE.size();
    }

    private record MethodKey(Method method, Object instance) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return this.method.equals(methodKey.method) && (this.instance == methodKey.instance || this.instance != null && this.instance.equals(methodKey.instance));
        }

        @Override
        public int hashCode() {
            return 31 * this.method.hashCode() + (this.instance != null ? this.instance.hashCode() : 0);
        }
    }
}

