/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.particles;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncParticleHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_PARTICLES_PER_TICK = 1000;
    private static volatile ExecutorService executorService;
    private static final BlockingQueue<ParticleTask> particleQueue;
    private static final ThreadLocal<BlockPos.MutableBlockPos> mutablePosCache;

    public static void init() {
        if (((Boolean)CoolConfig.ASYNC_PARTICLES.get()).booleanValue()) {
            int threads = Math.max(1, Math.min((Integer)CoolConfig.maxthreads.get(), Runtime.getRuntime().availableProcessors()));
            executorService = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
                Thread t = new Thread(r, "Async particle Worker");
                t.setDaemon(true);
                return t;
            });
            LOGGER.info("Async particle System initialized with {} threads", (Object)threads);
        }
    }

    public static void shutdown() {
        if (executorService != null) {
            ExecutorService es = executorService;
            executorService = null;
            es.shutdown();
            try {
                if (!es.awaitTermination(3L, TimeUnit.SECONDS)) {
                    es.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                es.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void addParticle(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (!((Boolean)CoolConfig.ASYNC_PARTICLES.get()).booleanValue() || level.f_46443_) {
            level.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
            return;
        }
        if (particleQueue.remainingCapacity() > 0) {
            particleQueue.offer(new ParticleTask(level, particle, x, y, z, xSpeed, ySpeed, zSpeed));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            AsyncParticleHandler.processParticles();
        }
    }

    private static void processParticles() {
        ParticleTask task;
        for (int processed = 0; processed < 1000 && (task = (ParticleTask)particleQueue.poll()) != null; ++processed) {
            ParticleTask finalTask = task;
            executorService.execute(() -> {
                BlockPos.MutableBlockPos pos;
                ServerLevel serverLevel = (ServerLevel)finalTask.level;
                if (serverLevel != null && serverLevel.m_46749_((BlockPos)(pos = mutablePosCache.get().m_122169_(finalTask.x(), finalTask.y(), finalTask.z())))) {
                    serverLevel.m_8767_(finalTask.particle(), finalTask.x(), finalTask.y(), finalTask.z(), 1, finalTask.xSpeed(), finalTask.ySpeed(), finalTask.zSpeed(), 1.0);
                }
            });
        }
    }

    static {
        particleQueue = new LinkedBlockingQueue<ParticleTask>();
        mutablePosCache = ThreadLocal.withInitial(BlockPos.MutableBlockPos::new);
    }

    private record ParticleTask(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }
}

