/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.carbonmc.graphene.api.IOptimizableEntity;
import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public final class EntityTickHelper {
    private static final AtomicReference<Set<class_1299<?>>> ENTITY_WHITELIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<class_1792>> ITEM_WHITELIST = new AtomicReference(Collections.emptySet());
    private static final Cache<class_1299<?>, Boolean> BOSS_MOB_CACHE = Caffeine.newBuilder().maximumSize(100L).executor(Runnable::run).build();
    private static final Set<class_1299<?>> BOSS_TYPES = ImmutableSet.of((Object)class_1299.field_6116, (Object)class_1299.field_6119, (Object)class_1299.field_6086, (Object)class_1299.field_38095);
    private static final ExecutorService TICK_EXECUTOR = Executors.newWorkStealingPool();
    private static volatile boolean optimizeEntitiesEnabled = true;
    private static volatile boolean tickRaidersInRaid = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    public static void onServerTick() {
        EntityTickHelper.updateConfigCache();
    }

    private static void updateConfigCache() {
        optimizeEntitiesEnabled = (Boolean)CoolConfig.optimizeEntities.get();
        tickRaidersInRaid = (Boolean)CoolConfig.tickRaidersInRaid.get();
        horizontalRange = (Integer)CoolConfig.horizontalRange.get();
        verticalRange = (Integer)CoolConfig.verticalRange.get();
    }

    public static void refreshWhitelists() {
        CompletableFuture.runAsync(() -> {
            ENTITY_WHITELIST.set((Set<class_1299<?>>)ImmutableSet.copyOf((Collection)((List)CoolConfig.entityWhitelist.get()).stream().map(s -> (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)s))).filter(Objects::nonNull).collect(Collectors.toSet())));
            ITEM_WHITELIST.set((Set<class_1792>)ImmutableSet.copyOf((Collection)((List)CoolConfig.itemWhitelist.get()).stream().map(s -> (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)s))).filter(Objects::nonNull).collect(Collectors.toSet())));
        }, TICK_EXECUTOR);
    }

    public static boolean shouldCancelTick(@NotNull class_1297 entity) {
        IOptimizableEntity opt;
        class_1309 living;
        if (!optimizeEntitiesEnabled) {
            return false;
        }
        class_1937 level = entity.method_37908();
        if (level == null) {
            return false;
        }
        if (entity instanceof class_1657 || ENTITY_WHITELIST.get().contains(entity.method_5864()) || entity instanceof class_3763) {
            return false;
        }
        if (!(entity instanceof class_1309) || !(living = (class_1309)entity).method_5805()) {
            return false;
        }
        if (entity instanceof IOptimizableEntity && (opt = (IOptimizableEntity)entity).shouldAlwaysTick()) {
            return false;
        }
        return EntityTickHelper.performFullChecks(living, level);
    }

    private static boolean performFullChecks(class_1309 entity, class_1937 level) {
        class_2338 pos = entity.method_24515();
        class_1299 type = entity.method_5864();
        if (EntityTickHelper.isBossMob(type, entity)) {
            return false;
        }
        if (tickRaidersInRaid && EntityTickHelper.isInRaid((class_1297)entity, level, pos)) {
            return false;
        }
        return !EntityTickHelper.checkNearbyPlayers(level, pos);
    }

    private static boolean isBossMob(class_1299<?> type, class_1309 entity) {
        return BOSS_TYPES.contains(type) || (Boolean)BOSS_MOB_CACHE.get(type, t -> {
            class_1308 mob;
            return entity instanceof class_1308 && (mob = (class_1308)entity).method_5987();
        }) != false;
    }

    private static boolean isInRaid(class_1297 entity, class_1937 level, class_2338 pos) {
        IOptimizableEntity opt;
        class_3218 serverLevel;
        return level instanceof class_3218 && (serverLevel = (class_3218)level).method_19503(pos) && (entity instanceof class_3763 || entity instanceof IOptimizableEntity && (opt = (IOptimizableEntity)entity).shouldTickInRaid());
    }

    private static boolean checkNearbyPlayers(class_1937 level, class_2338 pos) {
        if (level.method_18456().isEmpty()) {
            return false;
        }
        class_238 area = new class_238((double)(pos.method_10263() - horizontalRange), (double)(pos.method_10264() - verticalRange), (double)(pos.method_10260() - horizontalRange), (double)(pos.method_10263() + horizontalRange), (double)(pos.method_10264() + verticalRange), (double)(pos.method_10260() + horizontalRange));
        List players = level.method_18467(class_1657.class, area);
        for (class_1657 player : players) {
            if (!player.method_5805()) continue;
            return true;
        }
        return false;
    }

    public static void shutdown() {
        TICK_EXECUTOR.shutdownNow();
        try {
            if (!TICK_EXECUTOR.awaitTermination(1L, TimeUnit.SECONDS)) {
                TICK_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            TICK_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        EntityTickHelper.refreshWhitelists();
        EntityTickHelper.updateConfigCache();
    }
}

