/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.engine.cull;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.carbonmc.graphene.config.CoolConfig;
import net.carbonmc.graphene.engine.cull.RenderOptimizer;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;

public final class LeafOptiEngine {
    private static final Map<class_2350, class_2350[]> CONNECTED_DIRECTIONS = new EnumMap<class_2350, class_2350[]>(class_2350.class);
    private static final Cache<Long, Boolean> CULL_CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static boolean shouldCullFace(class_1922 level, class_2338 pos, class_2350 face) {
        long cacheKey = pos.method_10063() << 8 | (long)face.ordinal();
        Boolean cached = (Boolean)CULL_CACHE.getIfPresent((Object)cacheKey);
        if (cached != null) {
            return cached;
        }
        class_2338 adjacentPos = pos.method_10093(face);
        class_2680 adjacentState = level.method_8320(adjacentPos);
        if (!LeafOptiEngine.isLeaf(adjacentState)) {
            CULL_CACHE.put((Object)cacheKey, (Object)false);
            return false;
        }
        boolean result = (Boolean)CoolConfig.useAdvancedLeafCulling.get() != false && !RenderOptimizer.isInFallbackMode() ? RenderOptimizer.shouldCullBlockFace(level, pos, face) : LeafOptiEngine.checkSimpleConnection(level, adjacentPos, face);
        CULL_CACHE.put((Object)cacheKey, (Object)result);
        return result;
    }

    public static boolean checkSimpleConnection(class_1922 level, class_2338 pos, class_2350 face) {
        int required = (Integer)CoolConfig.minLeafConnections.get();
        int count = 0;
        for (class_2350 dir : CONNECTED_DIRECTIONS.get(face)) {
            if (dir == null || !LeafOptiEngine.isLeaf(level.method_8320(pos.method_10093(dir))) || ++count < required) continue;
            return true;
        }
        return false;
    }

    public static boolean checkSimpleConnection(class_1922 level, class_2338 pos) {
        return LeafOptiEngine.checkConnectedLeaves(level, pos, null);
    }

    public static boolean checkConnectedLeaves(class_1922 level, class_2338 pos, @Nullable class_2350 face) {
        class_2350[] checkDirs;
        int required = (Integer)CoolConfig.minLeafConnections.get();
        int count = 0;
        for (class_2350 dir : checkDirs = face != null ? CONNECTED_DIRECTIONS.get(face) : class_2350.values()) {
            if (dir == null || !LeafOptiEngine.isLeaf(level.method_8320(pos.method_10093(dir))) || ++count < required) continue;
            return true;
        }
        return false;
    }

    private static boolean isLeaf(class_2680 state) {
        return state.method_26204() instanceof class_2397;
    }

    static {
        for (class_2350 face : class_2350.values()) {
            class_2350[] dirs = new class_2350[4];
            int i = 0;
            for (class_2350 dir : class_2350.values()) {
                if (dir == face || dir == face.method_10153()) continue;
                dirs[i++] = dir;
            }
            CONNECTED_DIRECTIONS.put(face, dirs);
        }
    }
}

