/*
 * Decompiled with CFR 0.152.
 */
package net.carbonmc.graphene.optimization;

import net.carbonmc.graphene.config.CoolConfig;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class MemoryCleaner {
    private static long lastCleanTime = 0L;

    public static void onServerTick(MinecraftServer server) {
        long interval;
        if (server.method_30002() == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCleanTime > (interval = (long)((Integer)CoolConfig.MEMORY_CLEAN_INTERVAL.get() * 1000))) {
            MemoryCleaner.cleanupResources(server);
            lastCleanTime = currentTime;
        }
    }

    private static void cleanupResources(MinecraftServer server) {
        if (server == null) {
            return;
        }
        if (((Boolean)CoolConfig.OPTIMIZE_ENTITY_CLEANUP.get()).booleanValue()) {
            for (class_3218 level : server.method_3738()) {
                level.method_27909().forEach(entity -> {
                    if (!entity.method_5805() && entity.field_6012 > 600) {
                        entity.method_31472();
                    }
                });
            }
        }
        if ((long)((Integer)CoolConfig.MEMORY_CLEAN_INTERVAL.get()).intValue() > lastCleanTime) {
            System.out.println("[Graphene] \u5185\u5b58\u6e05\u7406\u5b8c\u6210");
        }
    }
}

