/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.config.configs;

import java.util.Optional;
import lombok.Generated;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;

public final class Checker {
    public static boolean checkItemEquality(ItemStack itemStack, ResourceLocation resourceLocation) {
        Optional registryItem = BuiltInRegistries.ITEM.get(resourceLocation);
        return registryItem.isPresent() && ((Holder.Reference)registryItem.get()).is(itemStack.getItemHolder());
    }

    public static boolean checkTagContainItem(ItemStack itemStack, ResourceLocation resourceLocation) {
        TagKey itemTagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
        return itemStack.is(itemTagKey);
    }

    public static boolean checkIsThisMod(ItemStack itemStack, String modId) {
        return BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace().equals(modId);
    }

    public static boolean checkItemInItemList(ItemStack itemStack, ValidatedSet<ResourceLocation> resourceLocations) {
        ResourceLocation registryItem = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        return resourceLocations.contains((Object)registryItem);
    }

    public static boolean checkItemHasTagInTagList(ItemStack itemStack, ValidatedSet<String> tags) {
        return itemStack.getTags().map(x -> x.location().toString()).anyMatch(arg_0 -> tags.contains(arg_0));
    }

    public static boolean checkIsInThisModList(ItemStack itemStack, ValidatedSet<String> modId) {
        return modId.contains((Object)BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace());
    }

    public static boolean checkItemInItemList(LBItemEntity lbItemEntity, ValidatedSet<ResourceLocation> resourceLocations) {
        return resourceLocations.contains((Object)lbItemEntity.resourceLocation());
    }

    public static boolean checkItemHasTagInTagList(LBItemEntity lbItemEntity, ValidatedSet<String> tags) {
        return lbItemEntity.item().getItem().getTags().map(x -> x.location().toString()).anyMatch(arg_0 -> tags.contains(arg_0));
    }

    public static boolean checkIsInThisModList(LBItemEntity lbItemEntity, ValidatedSet<String> modId) {
        return modId.contains((Object)lbItemEntity.resourceLocation().getNamespace());
    }

    @Generated
    private Checker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

