/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.data.lbitementity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import me.clefal.lootbeams.config.ConfigHandlers;
import me.clefal.lootbeams.config.impl.ModifyingConfigHandler;
import me.clefal.lootbeams.data.lbitementity.InternalLBItemEntityProvider;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.modules.ILBModuleRenderCache;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class LBItemEntityCache
implements ILBModuleRenderCache<InternalLBItemEntityProvider, ItemEntity> {
    private static final Cache<ItemStack, LBItemEntity> cache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterAccess(30L, TimeUnit.SECONDS).build();
    private static final LBItemEntityCache INSTANCE = new LBItemEntityCache();
    private static final Object lock = new Object();
    private static boolean mark = false;

    public static LBItemEntity ask(ItemEntity entity) {
        ItemStack item = entity.getItem();
        LBItemEntity ifPresent = (LBItemEntity)cache.getIfPresent((Object)item);
        if (ifPresent == null) {
            INSTANCE.handle(InternalLBItemEntityProvider.INSTANCE, entity, mark);
        }
        return (LBItemEntity)cache.getIfPresent((Object)item);
    }

    protected static void provide(ItemEntity entity, LBItemEntity itemWithRarity) {
        cache.put((Object)entity.getItem(), (Object)itemWithRarity);
    }

    @Override
    public BiConsumer<InternalLBItemEntityProvider, ItemEntity> getDataHandler() {
        return (internalLbItemEntityProvider, itemEntity) -> {
            LBItemEntity lbItemEntity = InternalLBItemEntityProvider.getLBItemEntity(itemEntity);
            for (ModifyingConfigHandler handler : ConfigHandlers.INSTANCE.getHandlers()) {
                lbItemEntity = handler.modify(lbItemEntity);
            }
            LBItemEntityCache.provide(itemEntity, lbItemEntity);
            mark = false;
        };
    }
}

