/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.tooltip.nametag;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import me.clefal.lootbeams.LootBeamsConstants;
import me.clefal.lootbeams.config.configs.LootInfomationConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.events.TooltipsGatherNameAndRarityEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;

public class NameTagRenderer {
    public static void renderNameTag(PoseStack stack, MultiBufferSource buffer, LBItemEntity LBItemEntity2) {
        ItemEntity item = LBItemEntity2.item();
        LootInfomationConfig.nameTagSection nameTagSection2 = LootInfomationConfig.lootInfomationConfig.nameTag;
        if (Minecraft.m_91087_().f_91074_.m_6047_() || nameTagSection2.render_name_tag_on_look && NameTagRenderer.isLookingAt(Minecraft.m_91087_().f_91074_, (Entity)item, ((Float)nameTagSection2.name_tag_look_sensitivity.get()).floatValue())) {
            LBColor color = LBItemEntity2.rarity().color();
            float foregroundAlpha = ((Float)nameTagSection2.name_tag_text_alpha.get()).floatValue();
            float backgroundAlpha = ((Float)nameTagSection2.name_tag_background_alpha.get()).floatValue();
            double yOffset = ((Float)nameTagSection2.name_tag_y_offset.get()).floatValue();
            int foregroundColor = color.changeA((int)(foregroundAlpha * 255.0f)).argb();
            int backgroundColor = color.changeA((int)(foregroundAlpha * 255.0f)).argb();
            stack.m_85836_();
            stack.m_85837_(0.0, Math.min(1.0, Minecraft.m_91087_().f_91074_.m_20280_((Entity)item) * 0.025) + yOffset, 0.0);
            stack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            float nametagScale = ((Float)nameTagSection2.name_tag_scale.get()).floatValue();
            stack.m_85841_(-0.02f * nametagScale, -0.02f * nametagScale, 0.02f * nametagScale);
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            TooltipsGatherNameAndRarityEvent tooltipsGatherNameAndRarityEvent = new TooltipsGatherNameAndRarityEvent(LBItemEntity2);
            LootBeamsConstants.EVENT_BUS.post((Event)tooltipsGatherNameAndRarityEvent);
            ArrayList<Component> nameAndRarity = new ArrayList<Component>(tooltipsGatherNameAndRarityEvent.gather.values());
            stack.m_252880_(0.0f, 2.0f, -10.0f);
            for (Component c : nameAndRarity) {
                String s = c.getString();
                if (s.isBlank()) continue;
                NameTagRenderer.renderText(fontrenderer, stack, buffer, s, foregroundColor, backgroundColor, backgroundAlpha);
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                stack.m_252880_(0.0f, 9.0f, 0.0f);
            }
            stack.m_85849_();
        }
    }

    private static void renderText(Font fontRenderer, PoseStack stack, MultiBufferSource buffer, String text, int foregroundColor, int backgroundColor, float backgroundAlpha) {
        if (LootInfomationConfig.lootInfomationConfig.nameTag.add_text_border) {
            float w = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
            int bg = new Color(0, 0, 0, (int)(255.0f * backgroundAlpha)).getRGB();
            MutableComponent comp = Component.m_237113_((String)text);
            fontRenderer.m_168645_(comp.m_7532_(), w, 0.0f, foregroundColor, bg, stack.m_85850_().m_252922_(), buffer, 0xF000F0);
        } else {
            fontRenderer.m_271703_(text, (float)(-fontRenderer.m_92895_(text) / 2), 30.0f, foregroundColor, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, backgroundColor, 0xF000E0);
        }
    }

    public static boolean isLookingAt(LocalPlayer player, Entity target, double accuracy) {
        Vec3 difference = new Vec3(target.m_20185_() - player.m_20185_(), target.m_20188_() - player.m_20188_(), target.m_20189_() - player.m_20189_());
        double length = difference.m_82553_();
        double dot = Minecraft.m_91087_().m_91288_().m_20154_().m_82541_().m_82526_(difference.m_82541_());
        return dot > 1.0 - accuracy / length && !target.m_20145_();
    }
}

