/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.config.persistent;

import java.util.Set;
import me.clefal.lootbeams.config.configs.Checker;
import me.clefal.lootbeams.config.configs.CustomConfig;
import me.clefal.lootbeams.config.persistent.PersistentConfigData;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.events.RegisterConfigConditionEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;

public class EquipmentConditions
extends PersistentConfigData<RegisterConfigConditionEvent.RegisterEquipmentItemEvent> {
    public static final EquipmentConditions INSTANCE = new EquipmentConditions();

    public EquipmentConditions() {
        CustomConfig.EquipmentRegister equipmentRegister = CustomConfig.customConfig.equipmentRegister;
        this.conditions.add(item -> Checker.checkItemInItemList(item, equipmentRegister.by_name));
        this.conditions.add(item -> Checker.checkItemHasTagInTagList(item, equipmentRegister.by_tag));
        this.conditions.add(item -> Checker.checkIsInThisModList(item, equipmentRegister.by_modid));
    }

    public static boolean isEquipment(LBItemEntity lbItemEntity) {
        Set resourceLocations = (Set)CustomConfig.customConfig.equipmentRegister.blacklist_by_name.get();
        Item item = lbItemEntity.item().m_32055_().m_41720_();
        boolean b = item instanceof TieredItem;
        return !resourceLocations.contains(lbItemEntity.resourceLocation()) && (b || item instanceof ArmorItem || item instanceof ShieldItem || item instanceof BowItem || item instanceof CrossbowItem || item instanceof TridentItem || EquipmentConditions.INSTANCE.conditions.stream().anyMatch(x -> x.test(lbItemEntity)));
    }

    @Override
    public RegisterConfigConditionEvent.RegisterEquipmentItemEvent getEvent() {
        return new RegisterConfigConditionEvent.RegisterEquipmentItemEvent();
    }
}

