/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.beam;

import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.clefal.lootbeams.config.configs.LightConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.modules.beam.BeamRenderType;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProvider;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProviderModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamRenderer {
    public static void renderLootBeam(PoseStack stack, MultiBufferSource buffer, float partialTick, LBItemEntity LBItemEntity2) {
        float fadeDistance;
        ItemEntity itemEntity = LBItemEntity2.item();
        LBColor color = LBItemEntity2.rarity().color();
        int lifeTime = LBItemEntity2.fadeIn();
        LightConfig.Beam beamConfig = LightConfig.lightConfig.beam;
        LightConfig.Glow glowConfig = LightConfig.lightConfig.glow;
        int fadeInTime = (Integer)beamConfig.beam_fade_in_time.get();
        float fadeInFactor = 1.0f * (float)lifeTime / (float)fadeInTime;
        int argb = color.argb();
        int R = color.red();
        int G = color.green();
        int B = color.blue();
        float preBeamAlpha = ((Float)beamConfig.beam_alpha.get()).floatValue();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        double distance = player.m_20270_((Entity)itemEntity);
        if (distance > (double)(fadeDistance = ((Float)beamConfig.beam_fade_in_distance.get()).floatValue())) {
            float m = (float)distance - fadeDistance;
            preBeamAlpha *= 1.0f / Math.max(m / fadeDistance, 1.0f);
        }
        float beamRadius = 0.05f * ((Float)beamConfig.beam_radius.get()).floatValue();
        float beamHeight = ((Float)beamConfig.beam_height.get()).floatValue();
        float yOffset = ((Float)beamConfig.beam_y_offset.get()).floatValue();
        if (beamConfig.common_shorter_beam && LBItemEntity2.isCommon()) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        int beamAlpha = (int)(preBeamAlpha * 255.0f);
        Option<DynamicProvider> dynamicProvider1 = DynamicProviderModule.getDynamicProvider();
        if (dynamicProvider1.isDefined()) {
            beamAlpha = (int)((float)beamAlpha * Math.min(((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor(), 1.0f));
            beamHeight += ((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor() - 0.3f;
            beamRadius += 0.005f * ((DynamicProvider)dynamicProvider1.get()).getGlowFactor();
        }
        beamAlpha = (int)((float)beamAlpha * fadeInFactor);
        Vector3f playerPos = player.m_20318_(partialTick).m_252839_();
        Vector3f targetPos = itemEntity.m_20318_(partialTick).m_252839_();
        Vector3f direction = targetPos.sub((Vector3fc)playerPos).normalize();
        double v = Math.atan2(direction.x(), direction.z());
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252961_((float)v));
        stack.m_85836_();
        stack.m_252880_(0.0f, yOffset + 1.0f, 0.0f);
        VertexConsumer buffer1 = buffer.m_6299_(BeamRenderType.LOOT_BEAM_RENDERTYPE);
        buffer1.m_252986_(stack.m_85850_().m_252922_(), -beamRadius, -beamHeight, 0.01f).m_6122_(R, G, B, beamAlpha).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer1.m_252986_(stack.m_85850_().m_252922_(), -beamRadius, beamHeight, 0.01f).m_6122_(R, G, B, 0).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer1.m_252986_(stack.m_85850_().m_252922_(), beamRadius, beamHeight, 0.01f).m_6122_(R, G, B, 0).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer1.m_252986_(stack.m_85850_().m_252922_(), beamRadius, -beamHeight, 0.01f).m_6122_(R, G, B, beamAlpha).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        float glowRadius = beamRadius * 1.35f;
        int glowAlpha = (int)((float)beamAlpha * 0.55f);
        buffer1.m_252986_(stack.m_85850_().m_252922_(), -glowRadius, -beamHeight, 0.001f).m_6122_(R, G, B, glowAlpha).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer1.m_252986_(stack.m_85850_().m_252922_(), -glowRadius, beamHeight, 0.001f).m_6122_(R, G, B, 0).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer1.m_252986_(stack.m_85850_().m_252922_(), glowRadius, beamHeight, 0.001f).m_6122_(R, G, B, 0).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        buffer1.m_252986_(stack.m_85850_().m_252922_(), glowRadius, -beamHeight, 0.001f).m_6122_(R, G, B, glowAlpha).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_252939_(stack.m_85850_().m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        stack.m_85849_();
        stack.m_85849_();
        if (glowConfig.enable_glow && itemEntity.m_20096_()) {
            stack.m_85836_();
            stack.m_85837_(0.0, 0.01, 0.0);
            float radius = ((Float)glowConfig.glow_effect_radius.get()).floatValue();
            BeamRenderer.renderGlow(stack, buffer.m_6299_(BeamRenderType.GLOW), R, G, B, (int)((float)beamAlpha * 0.4f), radius);
            stack.m_85849_();
        }
        if (lifeTime < fadeInTime) {
            LBItemEntity2.updateFade();
        }
    }

    private static void renderGlow(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float radius) {
        PoseStack.Pose matrixentry = stack.m_85850_();
        Matrix4f matrixpose = matrixentry.m_252922_();
        Matrix3f matrixnormal = matrixentry.m_252943_();
        builder.m_252986_(matrixpose, -radius, 0.0f, -radius).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrixpose, -radius, 0.0f, radius).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrixpose, radius, 0.0f, radius).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrixpose, radius, 0.0f, -radius).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrixnormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

