/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.util;

import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.database.DatabaseManager;
import com.zefir.servercosmetics.ext.ICosmetic;
import com.zefir.servercosmetics.util.BodyCosmetic;
import com.zefir.servercosmetics.util.PacketUtil;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ArmorCosmetic
implements ICosmetic {
    private final class_3222 player;
    private final ItemType slotType;
    private ItemType itemType;
    private class_1799 cosmeticItemStack = class_1799.field_8037;
    private final BodyCosmetic bodyCosmeticDelegate;

    public ArmorCosmetic(class_3222 player, ItemType itemType) {
        this.player = player;
        this.slotType = itemType;
        this.itemType = itemType;
        this.bodyCosmeticDelegate = new BodyCosmetic(player, ArmorCosmetic.getBodyCosmeticType(itemType));
    }

    @Override
    public void equip(class_1799 newCosmeticStack, ItemType newType) {
        if (this.bodyCosmeticDelegate.getCosmeticItemStack() != class_1799.field_8037) {
            this.bodyCosmeticDelegate.unequip();
        }
        this.itemType = newType;
        this.cosmeticItemStack = newCosmeticStack.method_7972();
        System.out.println("Equip: " + String.valueOf(this.cosmeticItemStack) + " " + String.valueOf((Object)this.itemType));
        if (this.itemType == ItemType.HAT_BODY_COSMETIC || this.itemType == ItemType.CHESTPLATE_BODY_COSMETIC || this.itemType == ItemType.LEGGINGS_BODY_COSMETIC || this.itemType == ItemType.BOOTS_BODY_COSMETIC) {
            this.bodyCosmeticDelegate.equip(this.cosmeticItemStack, this.itemType);
            DatabaseManager.setCosmetic(this.player, this.slotType, class_1799.field_8037);
        } else {
            DatabaseManager.setCosmetic(this.player, this.itemType, this.cosmeticItemStack);
            DatabaseManager.setCosmetic(this.player, ArmorCosmetic.getBodyCosmeticType(this.itemType), class_1799.field_8037);
        }
        this.updatePlayerArmorView();
    }

    @Override
    public void init() {
        class_1799 stackFromDb = DatabaseManager.getCosmeticItemStack(this.player, this.itemType);
        if (stackFromDb.method_7960()) {
            stackFromDb = DatabaseManager.getCosmeticItemStack(this.player, ArmorCosmetic.getBodyCosmeticType(this.itemType));
            this.equip(stackFromDb, ArmorCosmetic.getBodyCosmeticType(this.itemType));
        } else {
            this.equip(stackFromDb, this.itemType);
        }
    }

    @Override
    public void tick() {
        if (this.cosmeticItemStack.method_7960()) {
            return;
        }
        if (this.bodyCosmeticDelegate.getCosmeticItemStack() != class_1799.field_8037) {
            this.bodyCosmeticDelegate.tick();
        }
        this.updatePlayerArmorView();
    }

    @Override
    public ItemType getItemType() {
        return this.slotType;
    }

    @Nullable
    public class_1297 getBodyCosmeticModel() {
        if (this.bodyCosmeticDelegate.getCosmeticItemStack() != class_1799.field_8037) {
            return this.bodyCosmeticDelegate.getBodyCosmeticsModel();
        }
        return null;
    }

    private void updatePlayerArmorView() {
        class_1799 itemStackToSend = !this.cosmeticItemStack.method_7960() ? this.cosmeticItemStack : this.player.method_31548().method_7372(3 - (ArmorCosmetic.getSlotFor(this.slotType) - 5));
        PacketUtil.sendInventorySlotPacket(this.player, ArmorCosmetic.getSlotFor(this.slotType), itemStackToSend);
    }

    private static int getSlotFor(ItemType type) {
        return switch (type) {
            case ItemType.HAT -> 5;
            case ItemType.CHESTPLATE -> 6;
            case ItemType.LEGGINGS -> 7;
            case ItemType.BOOTS -> 8;
            default -> throw new IllegalArgumentException("Invalid ItemType for ArmorCosmetic: " + String.valueOf((Object)type));
        };
    }

    private static ItemType getBodyCosmeticType(ItemType type) {
        return switch (type) {
            case ItemType.HAT -> ItemType.HAT_BODY_COSMETIC;
            case ItemType.CHESTPLATE -> ItemType.CHESTPLATE_BODY_COSMETIC;
            case ItemType.LEGGINGS -> ItemType.LEGGINGS_BODY_COSMETIC;
            case ItemType.BOOTS -> ItemType.BOOTS_BODY_COSMETIC;
            default -> type;
        };
    }

    @Generated
    public class_1799 getCosmeticItemStack() {
        return this.cosmeticItemStack;
    }
}

