/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.zefir.servercosmetics.data.BodyCosmeticsData;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.database.DatabaseManager;
import com.zefir.servercosmetics.ext.ICosmetic;
import com.zefir.servercosmetics.util.Utils;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2379;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2716;
import net.minecraft.class_2726;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class BodyCosmetic
implements ICosmetic {
    final class_3222 player;
    final ItemType itemType;
    private final class_1297 bodyCosmeticsModel;
    class_1799 cosmeticItemStack = class_1799.field_8037;
    class_1799 cosmeticItemStackWhenSneaking = class_1799.field_8037;
    private BodyCosmeticsData cosmeticData;
    private final boolean useArmorStand = true;
    private boolean isHidden = false;
    private boolean isTilted = false;

    public BodyCosmetic(class_3222 player, ItemType itemType) {
        this.bodyCosmeticsModel = new class_1531(class_1299.field_6131, (class_1937)player.method_51469());
        this.player = player;
        this.itemType = itemType;
    }

    @Override
    public void equip(class_1799 is, ItemType _type) {
        DatabaseManager.setCosmetic(this.player, this.itemType, is);
        if (is == class_1799.field_8037) {
            this.unequip();
            return;
        }
        this.init();
    }

    @Override
    public void init() {
        this.cosmeticItemStack = DatabaseManager.getCosmeticItemStack(this.player, this.itemType);
        if (this.cosmeticItemStack != class_1799.field_8037) {
            this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2716(new int[]{this.bodyCosmeticsModel.method_5628()}));
            if (DatabaseManager.getCosmeticEntry(this.player, this.itemType) != null) {
                this.cosmeticData = (BodyCosmeticsData)Objects.requireNonNull(DatabaseManager.getCosmeticEntry(this.player, this.itemType)).cosmeticData();
                this.cosmeticItemStackWhenSneaking = Utils.getTiltedItemStack(this.cosmeticItemStack, this.cosmeticData.polymerModelWhenSneaking());
            } else {
                this.cosmeticItemStackWhenSneaking = this.cosmeticItemStack;
            }
            this.bodyCosmeticsModel.method_5814(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
            this.bodyCosmeticsModel.method_5684(true);
            this.bodyCosmeticsModel.method_5875(true);
            this.bodyCosmeticsModel.method_5648(true);
            ((class_1531)this.bodyCosmeticsModel).method_6919(new class_2379(0.0f, 0.0f, 0.0f));
            this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2604(this.bodyCosmeticsModel, 1, this.bodyCosmeticsModel.method_24515()));
            this.setItem(this.cosmeticItemStack);
            this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2739(this.bodyCosmeticsModel.method_5628(), this.bodyCosmeticsModel.method_5841().method_46357()));
            this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2752((class_1297)this.player));
            this.bodyCosmeticsModel.method_5804((class_1297)this.player);
        }
    }

    @Override
    public void tick() {
        if (this.cosmeticItemStack == class_1799.field_8037) {
            return;
        }
        this.bodyCosmeticsModel.method_36456(this.player.field_6283);
        this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2726(this.bodyCosmeticsModel, (byte)class_3532.method_15375((float)(this.bodyCosmeticsModel.method_36454() * 256.0f / 360.0f))));
        if (this.cosmeticData != null && this.cosmeticData.offsetWhenSneaking()) {
            if (this.player.method_5715() && !this.isTilted) {
                this.setItem(this.cosmeticItemStackWhenSneaking);
                this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2739(this.bodyCosmeticsModel.method_5628(), this.bodyCosmeticsModel.method_5841().method_46357()));
                this.isTilted = true;
            } else if (!this.player.method_5715() && this.isTilted) {
                this.setItem(this.cosmeticItemStack);
                this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2739(this.bodyCosmeticsModel.method_5628(), this.bodyCosmeticsModel.method_5841().method_46357()));
                this.isTilted = false;
            }
        }
        if (this.player.method_5681() || this.player.method_20448() && !this.isHidden) {
            this.setItem(class_1799.field_8037);
            this.isHidden = true;
        } else if (!this.player.method_5681() && !this.player.method_20448() && this.isHidden) {
            this.setItem(this.cosmeticItemStack);
            this.isHidden = false;
        }
    }

    private void setItem(class_1799 itemStack) {
        ImmutableList equipmentList = ImmutableList.of((Object)new Pair((Object)class_1304.field_6169, (Object)itemStack));
        this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2744(this.bodyCosmeticsModel.method_5628(), (List)equipmentList));
    }

    public void unequip() {
        this.bodyCosmeticsModel.method_5848();
        this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2716(new int[]{this.bodyCosmeticsModel.method_5628()}));
        this.player.method_51469().method_14178().method_18751((class_1297)this.player, (class_2596)new class_2752((class_1297)this.player));
        System.out.println("Unequipping");
        this.cosmeticItemStack = class_1799.field_8037;
        this.cosmeticItemStackWhenSneaking = class_1799.field_8037;
        this.isHidden = false;
        this.isTilted = false;
    }

    @Override
    @Generated
    public ItemType getItemType() {
        return this.itemType;
    }

    @Generated
    public class_1297 getBodyCosmeticsModel() {
        return this.bodyCosmeticsModel;
    }

    @Generated
    public class_1799 getCosmeticItemStack() {
        return this.cosmeticItemStack;
    }
}

