/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.config;

import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.util.Utils;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.comments.format.YamlCommentFormat;
import org.simpleyaml.configuration.file.YamlFile;

public abstract class AbstractGuiConfig {
    protected final Path configFilePath;
    protected YamlFile yamlFile;
    protected String guiNameString;
    protected int[] displaySlots;
    protected String permissionOpenGui;
    protected String messageUnlockedString;
    protected String messageLockedString;
    protected boolean pageIndicatorEnabled;
    protected boolean replaceInventory;
    private List<String> disabledFilters;
    class_3917<class_1707> screenHandlerType;
    static final Map<String, Map<String, Object>> buttonDefaults = new HashMap<String, Map<String, Object>>();
    protected final Map<String, ConfigManager.NavigationButton> navigationButtons = new HashMap<String, ConfigManager.NavigationButton>();

    public AbstractGuiConfig(String configFileName) {
        this.configFilePath = ConfigManager.SERVER_COSMETICS_DIR.resolve(configFileName);
    }

    public void init() {
        this.yamlFile = new YamlFile(this.configFilePath.toAbsolutePath().toString());
        try {
            this.yamlFile.createOrLoadWithComments();
            this.setupDefaultConfig(this.yamlFile);
            this.yamlFile.loadWithComments();
            this.loadCommonConfig(this.yamlFile);
            this.loadSpecificConfig(this.yamlFile);
            this.loadAllNavigationButtons(this.yamlFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create or load " + this.configFilePath.getFileName().toString(), e);
        }
    }

    private void setupDefaultConfig(YamlFile file) {
        file.setCommentFormat(YamlCommentFormat.PRETTY);
        file.options().headerFormatter().prefixFirst("###############################").commentPrefix("## ").commentSuffix(" ##").suffixLast("###############################");
        file.setHeader(this.getGuiConfigHeader());
        this.addCommonDefaults(file);
        this.addSpecificDefaults(file);
        ConfigurationSection buttonsSection = file.getConfigurationSection("buttons");
        if (buttonsSection == null) {
            buttonsSection = file.createSection("buttons");
        }
        this.addDefaultButtons(buttonsSection);
        try {
            file.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save default yml configuration for " + file.getFilePath(), e);
        }
    }

    private void loadCommonConfig(YamlFile file) {
        this.guiNameString = file.getString("guiName");
        this.displaySlots = file.getIntegerList("displaySlots").stream().mapToInt(Integer::intValue).toArray();
        this.permissionOpenGui = file.getString("permissions.openGui");
        this.messageUnlockedString = file.getString("messages.unlocked");
        this.messageLockedString = file.getString("messages.locked");
        this.pageIndicatorEnabled = file.getBoolean("pageIndicatorEnabled", false);
        this.replaceInventory = file.getBoolean("replaceInventory");
        this.disabledFilters = file.getStringList("disabledFilters");
    }

    protected void addCommonDefaults(YamlFile file) {
        file.addDefault("guiName", (Object)"Default GUI Name");
        file.addDefault("displaySlots", List.of(19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43));
        file.addDefault("permissions.openGui", (Object)"servercosmetics.gui.default");
        file.addDefault("messages.unlocked", (Object)"&a(Unlocked)");
        file.addDefault("messages.locked", (Object)"&c(Locked)");
        file.addDefault("pageIndicatorEnabled", (Object)false);
        file.addDefault("replaceInventory", (Object)false);
        this.loadGuiSize(file.getInt("guiRows", 6));
        file.addDefault("disabledFilters", List.of());
    }

    private void loadGuiSize(int guiRows) {
        if (guiRows < 1 || guiRows > 6) {
            ServerCosmetics.LOGGER.warn("Invalid guiRows value '{}' in {}. Must be between 1 and 6. Defaulting to 6.", (Object)guiRows, (Object)this.configFilePath.getFileName());
            guiRows = 6;
        }
        this.screenHandlerType = switch (guiRows) {
            case 1 -> class_3917.field_18664;
            case 2 -> class_3917.field_18665;
            case 3 -> class_3917.field_17326;
            case 4 -> class_3917.field_18666;
            case 5 -> class_3917.field_18667;
            default -> class_3917.field_17327;
        };
    }

    protected void loadNavigationButton(YamlFile yamlFile, String buttonKey) {
        String textureName;
        String basePath = "buttons." + buttonKey;
        if (!yamlFile.isConfigurationSection(basePath)) {
            ServerCosmetics.LOGGER.warn("Button configuration for '{}' not found in {}.", (Object)buttonKey, (Object)this.configFilePath.getFileName());
            return;
        }
        String baseItemString = yamlFile.getString(basePath + ".item");
        if (baseItemString == null || baseItemString.isEmpty()) {
            ServerCosmetics.LOGGER.error("Button '{}' in {} is missing 'item' field.", (Object)buttonKey, (Object)this.configFilePath.getFileName());
            return;
        }
        Object complitedItemString = baseItemString.contains(":") ? baseItemString : "minecraft:" + baseItemString.toLowerCase();
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)complitedItemString));
        if (item == class_7923.field_41178.method_10223(class_7923.field_41178.method_10137()) && !((String)complitedItemString).equals(class_7923.field_41178.method_10137().toString())) {
            ServerCosmetics.LOGGER.error("Button '{}' in {} has invalid item id: {}. Defaulting to paper.", new Object[]{buttonKey, this.configFilePath.getFileName(), complitedItemString});
            item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)"minecraft:paper"));
            complitedItemString = "minecraft:paper";
        }
        PolymerModelData polymerModelData = null;
        if (yamlFile.isSet(basePath + ".textureName") && (textureName = yamlFile.getString(basePath + ".textureName")) != null && !textureName.isEmpty()) {
            try {
                polymerModelData = PolymerResourcePackUtils.requestModel((class_1792)item, (class_2960)class_2960.method_60655((String)"servercosmetics", (String)("item/" + textureName)));
            }
            catch (Exception e) {
                ServerCosmetics.LOGGER.error("Failed to request model for button '{}' (item: {}, texture: {}): {}", new Object[]{buttonKey, complitedItemString, textureName, e.getMessage()});
            }
        }
        List loreStrings = yamlFile.getStringList(basePath + ".lore");
        this.navigationButtons.put(buttonKey, new ConfigManager.NavigationButton(Utils.formatDisplayName(yamlFile.getString(basePath + ".name", "Button " + buttonKey)), item, polymerModelData, yamlFile.getInt(basePath + ".slotIndex"), loreStrings));
    }

    protected void addDefaultButtonToSection(ConfigurationSection buttonsSection, String buttonName, Map<String, Object> properties) {
        ConfigurationSection buttonSection = buttonsSection.getConfigurationSection(buttonName);
        if (buttonSection == null) {
            buttonSection = buttonsSection.createSection(buttonName);
        }
        ConfigurationSection finalButtonSection = buttonSection;
        properties.forEach((key, value) -> {
            if (!finalButtonSection.contains(key)) {
                finalButtonSection.set(key, value);
            }
        });
    }

    public class_2561 getGuiName() {
        return Utils.formatDisplayName(this.guiNameString);
    }

    public class_2561 getMessageUnlocked() {
        return Utils.formatDisplayName(this.messageUnlockedString);
    }

    public class_2561 getMessageLocked() {
        return Utils.formatDisplayName(this.messageLockedString);
    }

    public ConfigManager.NavigationButton getButtonConfig(String buttonKey) {
        ConfigManager.NavigationButton button = this.navigationButtons.get(buttonKey);
        if (button == null) {
            ServerCosmetics.LOGGER.warn("Requested non-existent button config: '{}' from {}", (Object)buttonKey, (Object)this.configFilePath.getFileName());
            return new ConfigManager.NavigationButton((class_2561)class_2561.method_43470((String)"Error"), (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)"minecraft:barrier")), null, 0, Collections.emptyList());
        }
        return button;
    }

    protected abstract String getGuiConfigHeader();

    protected abstract void addSpecificDefaults(YamlFile var1);

    protected abstract void loadSpecificConfig(YamlFile var1);

    protected void addDefaultButtons(ConfigurationSection buttonsSection) {
        buttonDefaults.put("next", Map.of("name", "Next", "item", "minecraft:paper", "textureName", "next", "slotIndex", 51));
        buttonDefaults.put("previous", Map.of("name", "Back", "item", "minecraft:paper", "textureName", "previous", "slotIndex", 47));
        buttonDefaults.put("removeSkin", Map.of("name", "Remove skin", "item", "minecraft:paper", "textureName", "remove", "slotIndex", 49));
        buttonDefaults.put("filter.show-owned-skins-enabled", Map.of("name", "&bOwned Cosmetics Filter", "item", "minecraft:diamond_chestplate", "slotIndex", 10, "lore", List.of("&aShow owned cosmetics only <green>(Enabled)", "", "&aClick to change the mode!", "")));
        buttonDefaults.put("filter.show-owned-skins-disabled", Map.of("name", "&bOwned Cosmetics Filter", "item", "minecraft:golden_chestplate", "slotIndex", 10, "lore", List.of("&7Show owned cosmetics only <blue>(Disabled)", "", "&aClick to change the mode!", "")));
        buttonDefaults.put("pageIndicator", Map.of("name", "Page", "item", "minecraft:paper", "slotIndex", 53));
    }

    protected void loadAllNavigationButtons(YamlFile file) {
        this.loadNavigationButton(file, "next");
        this.loadNavigationButton(file, "previous");
        this.loadNavigationButton(file, "removeSkin");
        this.loadNavigationButton(file, "pageIndicator");
        this.loadNavigationButton(file, "filter.show-owned-skins-enabled");
        this.loadNavigationButton(file, "filter.show-owned-skins-disabled");
    }

    @Generated
    public String getGuiNameString() {
        return this.guiNameString;
    }

    @Generated
    public int[] getDisplaySlots() {
        return this.displaySlots;
    }

    @Generated
    public String getPermissionOpenGui() {
        return this.permissionOpenGui;
    }

    @Generated
    public String getMessageUnlockedString() {
        return this.messageUnlockedString;
    }

    @Generated
    public String getMessageLockedString() {
        return this.messageLockedString;
    }

    @Generated
    public boolean isPageIndicatorEnabled() {
        return this.pageIndicatorEnabled;
    }

    @Generated
    public boolean isReplaceInventory() {
        return this.replaceInventory;
    }

    @Generated
    public List<String> getDisabledFilters() {
        return this.disabledFilters;
    }

    @Generated
    public class_3917<class_1707> getScreenHandlerType() {
        return this.screenHandlerType;
    }

    @Generated
    public Map<String, ConfigManager.NavigationButton> getNavigationButtons() {
        return this.navigationButtons;
    }
}

