/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics;

import com.zefir.servercosmetics.command.CosmeticCommands;
import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.database.DatabaseManager;
import com.zefir.servercosmetics.gui.resources.GuiTextures;
import com.zefir.servercosmetics.gui.resources.UiResourceCreator;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCosmetics
implements ModInitializer {
    public static final String MOD_ID = "servercosmetics";
    public static final String VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("servercosmetics").get()).getMetadata().getVersion().getFriendlyString();
    public static final boolean DEV_ENV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"servercosmetics");
    public static MinecraftServer SERVER;

    public void onInitialize() {
        if (VERSION.contains("-dev.")) {
            LOGGER.warn("=====================================================");
            LOGGER.warn("You are using development version of ServerCosmetics!");
            LOGGER.warn("Support is limited, as features might be unfinished!");
            LOGGER.warn("You are on your own!");
            LOGGER.warn("=====================================================");
        }
        ConfigManager.registerConfigs();
        DatabaseManager.init();
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        CosmeticCommands.registerCommands();
        UiResourceCreator.setup();
        GuiTextures.register();
        if (PolymerResourcePackUtils.addModAssets((String)MOD_ID)) {
            LOGGER.info("Successfully added mod assets for servercosmetics");
        } else {
            LOGGER.error("Failed to add mod assets for servercosmetics");
        }
        PolymerResourcePackUtils.markAsRequired();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private void onServerStarting(MinecraftServer server) {
        SERVER = server;
    }
}

