/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.config;

import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.AbstractGuiConfig;
import com.zefir.servercosmetics.gui.resources.GuiTextures;
import com.zefir.servercosmetics.util.Utils;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.file.YamlFile;

public class CosmeticsGUIConfig
extends AbstractGuiConfig {
    private static int[] colorSlots;
    private static int[] colorGradientSlots;
    private static int colorInputSlot;
    private static int colorOutputSlot;
    private static String[] colorHexValues;
    private static String colorPickerGUINameString;
    private static float saturationAdjustmentValue;
    private static String signType;
    private static PolymerModelData paintItemPolymerModelData;
    private static class_1767 signColor;
    private static List<String> textLines;
    private static String successMessageString;
    private static String errorMessageString;
    private static boolean bodyCosmeticsAutoAlignment;

    public CosmeticsGUIConfig() {
        super("CosmeticsGUI.yml");
    }

    @Override
    protected String getGuiConfigHeader() {
        return "Cosmetics GUI Config File";
    }

    @Override
    protected void addSpecificDefaults(YamlFile file) {
        file.addDefault("slots.colorInput", (Object)28);
        file.addDefault("slots.colorOutput", (Object)34);
        file.addDefault("paintItemModelPath", (Object)"paint_button");
        file.addDefault("slots.color", (Object)new int[]{21, 22, 23, 30, 31, 32, 39, 40, 41});
        file.addDefault("slots.colorGradient", (Object)new int[]{1, 2, 3, 4, 5, 6, 7});
        file.addDefault("colorPicker.hexValues", (Object)new String[]{"ff0000", "ff7700", "ffff00", "ff0099", "ffffff", "09ff00", "8800ff", "0000ff", "00ffff"});
        file.addDefault("colorPicker.name", (Object)"Color Picker");
        file.addDefault("colorPicker.saturationAdjustmentValue", (Object)Float.valueOf(20.0f));
        file.addDefault("permissions.openGui", (Object)"servercosmetics.gui.cosmetics");
        file.addDefault("colorInput.signType", (Object)"minecraft:acacia_wall_sign");
        file.addDefault("colorInput.signColor", (Object)"WHITE");
        file.addDefault("colorInput.textLines", List.of("Enter the color in", "HEX format", "Example: #FFFFFF"));
        file.addDefault("colorInput.messages.success", (Object)"&aColor successfully changed!");
        file.addDefault("colorInput.messages.error", (Object)"&cIncorrect color format!");
        file.addDefault("bodyCosmeticsAutoAlignment", (Object)true);
        if (!file.contains("displaySlots")) {
            file.set("displaySlots", List.of(19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43));
        }
    }

    @Override
    protected void loadSpecificConfig(YamlFile file) {
        colorSlots = file.getIntegerList("slots.color").stream().mapToInt(Integer::intValue).toArray();
        colorGradientSlots = file.getIntegerList("slots.colorGradient").stream().mapToInt(Integer::intValue).toArray();
        colorInputSlot = file.getInt("slots.colorInput");
        colorOutputSlot = file.getInt("slots.colorOutput");
        colorHexValues = file.getStringList("colorPicker.hexValues").toArray(new String[0]);
        colorPickerGUINameString = file.getString("colorPicker.name");
        saturationAdjustmentValue = (float)file.getDouble("colorPicker.saturationAdjustmentValue", 20.0);
        bodyCosmeticsAutoAlignment = file.getBoolean("bodyCosmeticsAutoAlignment", true);
        String paintItemModelPath = file.getString("paintItemModelPath");
        if (paintItemModelPath != null && !paintItemModelPath.isEmpty()) {
            try {
                paintItemPolymerModelData = PolymerResourcePackUtils.requestModel((class_1792)class_1802.field_18138, (class_2960)class_2960.method_60655((String)"servercosmetics", (String)("item/" + paintItemModelPath)));
            }
            catch (Exception e) {
                ServerCosmetics.LOGGER.error("Failed to load paintItemModelData for path '{}': {}", (Object)paintItemModelPath, (Object)e.getMessage());
                paintItemPolymerModelData = null;
            }
        } else {
            paintItemPolymerModelData = null;
        }
        signType = file.getString("colorInput.signType");
        try {
            signColor = class_1767.valueOf((String)file.getString("colorInput.signColor", "WHITE").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ServerCosmetics.LOGGER.warn("Invalid signColor '{}' in CosmeticsGUI.yml, defaulting to WHITE.", (Object)file.getString("colorInput.signColor"));
            signColor = class_1767.field_7952;
        }
        textLines = file.getStringList("colorInput.textLines");
        successMessageString = file.getString("colorInput.messages.success");
        errorMessageString = file.getString("colorInput.messages.error");
    }

    @Override
    protected void addDefaultButtons(ConfigurationSection buttonsSection) {
        super.addDefaultButtons(buttonsSection);
        buttonDefaults.put("toggleColorView", Map.of("name", "Toggle view", "item", "minecraft:diamond_chestplate", "slotIndex", 10));
        buttonDefaults.put("enterColor", Map.of("name", "Enter custom color", "item", "minecraft:oak_sign", "slotIndex", 9, "lore", List.of("\u00a7eEnter the color in HEX format", "\u00a7ein the first line of the sign")));
        buttonDefaults.put("decreaseBrightness", Map.of("name", "Decrease brightness", "item", "minecraft:paper", "textureName", "previous", "slotIndex", 15));
        buttonDefaults.put("increaseBrightness", Map.of("name", "Increase brightness", "item", "minecraft:paper", "textureName", "next", "slotIndex", 16));
        buttonDefaults.put("filter.hats-disabled", Map.of("name", "<blue>Hats", "item", "minecraft:leather_helmet", "slotIndex", 12, "lore", List.of()));
        buttonDefaults.put("filter.hats-enabled", Map.of("name", "<blue>Hats", "item", "minecraft:diamond_helmet", "slotIndex", 12, "lore", List.of()));
        buttonDefaults.put("filter.body-cosmetics-disabled", Map.of("name", "<blue>Body Cosmetics", "item", "minecraft:chainmail_chestplate", "slotIndex", 13, "lore", List.of()));
        buttonDefaults.put("filter.body-cosmetics-enabled", Map.of("name", "<blue>Body Cosmetics", "item", "minecraft:diamond_chestplate", "slotIndex", 13, "lore", List.of()));
        buttonDefaults.put("filter.chestplate-cosmetics-disabled", Map.of("name", "<blue>Chestplate Cosmetics", "item", "minecraft:leather_chestplate", "slotIndex", 14, "lore", List.of()));
        buttonDefaults.put("filter.chestplate-cosmetics-enabled", Map.of("name", "<blue>Chestplate Cosmetics", "item", "minecraft:diamond_chestplate", "slotIndex", 14, "lore", List.of()));
        buttonDefaults.put("filter.leggings-cosmetics-disabled", Map.of("name", "<blue>Leggings Cosmetics", "item", "minecraft:leather_leggings", "slotIndex", 15, "lore", List.of()));
        buttonDefaults.put("filter.leggings-cosmetics-enabled", Map.of("name", "<blue>Leggings Cosmetics", "item", "minecraft:diamond_leggings", "slotIndex", 15, "lore", List.of()));
        buttonDefaults.put("filter.boots-cosmetics-disabled", Map.of("name", "<blue>Boots Cosmetics", "item", "minecraft:leather_boots", "slotIndex", 16, "lore", List.of()));
        buttonDefaults.put("filter.boots-cosmetics-enabled", Map.of("name", "<blue>Boots Cosmetics", "item", "minecraft:diamond_boots", "slotIndex", 16, "lore", List.of()));
        buttonDefaults.forEach((buttonName, properties) -> this.addDefaultButtonToSection(buttonsSection, (String)buttonName, (Map<String, Object>)properties));
    }

    @Override
    protected void loadAllNavigationButtons(YamlFile file) {
        super.loadAllNavigationButtons(file);
        this.loadNavigationButton(file, "toggleColorView");
        this.loadNavigationButton(file, "enterColor");
        this.loadNavigationButton(file, "decreaseBrightness");
        this.loadNavigationButton(file, "increaseBrightness");
        this.loadNavigationButton(file, "filter.hats-disabled");
        this.loadNavigationButton(file, "filter.hats-enabled");
        this.loadNavigationButton(file, "filter.body-cosmetics-disabled");
        this.loadNavigationButton(file, "filter.body-cosmetics-enabled");
        this.loadNavigationButton(file, "filter.chestplate-cosmetics-disabled");
        this.loadNavigationButton(file, "filter.chestplate-cosmetics-enabled");
        this.loadNavigationButton(file, "filter.leggings-cosmetics-disabled");
        this.loadNavigationButton(file, "filter.leggings-cosmetics-enabled");
        this.loadNavigationButton(file, "filter.boots-cosmetics-disabled");
        this.loadNavigationButton(file, "filter.boots-cosmetics-enabled");
    }

    public static List<String> getTextLines() {
        return new ArrayList<String>(textLines);
    }

    public static class_2561 getSuccessColorChangeMessage() {
        return Utils.formatDisplayName(successMessageString);
    }

    public static class_2561 getErrorColorChangeMessage() {
        return Utils.formatDisplayName(errorMessageString);
    }

    public static class_2561 getColorPickerGUIName() {
        return Utils.formatDisplayName(colorPickerGUINameString);
    }

    @Override
    public class_2561 getGuiName() {
        return GuiTextures.COSMETICS_MENU.apply(Utils.formatDisplayName(this.guiNameString));
    }

    @Generated
    public static int[] getColorSlots() {
        return colorSlots;
    }

    @Generated
    public static int[] getColorGradientSlots() {
        return colorGradientSlots;
    }

    @Generated
    public static int getColorInputSlot() {
        return colorInputSlot;
    }

    @Generated
    public static int getColorOutputSlot() {
        return colorOutputSlot;
    }

    @Generated
    public static String[] getColorHexValues() {
        return colorHexValues;
    }

    @Generated
    public static String getColorPickerGUINameString() {
        return colorPickerGUINameString;
    }

    @Generated
    public static float getSaturationAdjustmentValue() {
        return saturationAdjustmentValue;
    }

    @Generated
    public static String getSignType() {
        return signType;
    }

    @Generated
    public static PolymerModelData getPaintItemPolymerModelData() {
        return paintItemPolymerModelData;
    }

    @Generated
    public static class_1767 getSignColor() {
        return signColor;
    }

    @Generated
    public static String getSuccessMessageString() {
        return successMessageString;
    }

    @Generated
    public static String getErrorMessageString() {
        return errorMessageString;
    }

    @Generated
    public static boolean isBodyCosmeticsAutoAlignment() {
        return bodyCosmeticsAutoAlignment;
    }
}

