/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.data;

import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.data.ArmorCosmeticsData;
import com.zefir.servercosmetics.data.BodyCosmeticsData;
import com.zefir.servercosmetics.data.CustomItemEntry;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.data.Tags;
import com.zefir.servercosmetics.datagen.RuntimeModelManager;
import com.zefir.servercosmetics.util.Utils;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.simpleyaml.configuration.file.YamlFile;

public class CustomItemRegistry {
    private static final List<CustomItemEntry> cosmeticsList = new CopyOnWriteArrayList<CustomItemEntry>();
    private static boolean legacyMode = false;

    public static void initialize() {
        RuntimeModelManager.clearRequestedModels();
        CustomItemRegistry.loadAllCosmetics();
        CustomItemRegistry.loadAllItemSkins();
    }

    public static void reloadAll() {
        CustomItemRegistry.clearAll();
        CustomItemRegistry.initialize();
    }

    public static void reloadCosmetics() {
        cosmeticsList.clear();
        CustomItemRegistry.loadAllCosmetics();
    }

    public static void reloadItemSkins() {
        cosmeticsList.clear();
        CustomItemRegistry.loadAllItemSkins();
    }

    private static void clearAll() {
        cosmeticsList.clear();
    }

    private static void loadAllCosmetics() {
        Path cosmeticsDir = ConfigManager.SERVER_COSMETICS_DIR.resolve("Cosmetics");
        CustomItemRegistry.loadItemsFromDirectory(cosmeticsDir, "cosmetic-item");
    }

    private static void loadAllItemSkins() {
        Path itemSkinsDir = ConfigManager.SERVER_COSMETICS_DIR.resolve("ItemSkins");
        CustomItemRegistry.loadItemsFromDirectory(itemSkinsDir, null);
    }

    private static void loadItemsFromDirectory(Path directory, String itemPropertiesRootNode) {
        try {
            if (Files.notExists(directory, new LinkOption[0])) {
                Files.createDirectories(directory, new FileAttribute[0]);
                ServerCosmetics.LOGGER.info("Created directory: {}", (Object)directory.toAbsolutePath());
                return;
            }
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                ServerCosmetics.LOGGER.error("Path is not a directory: {}", (Object)directory.toAbsolutePath());
                return;
            }
        }
        catch (IOException e) {
            ServerCosmetics.LOGGER.error("Failed to create or access directory: {}", (Object)directory, (Object)e);
            return;
        }
        List<Path> files = Utils.listFiles(directory);
        for (Path filePath : files) {
            if (!filePath.toString().toLowerCase().endsWith(".yml")) continue;
            String fileName = filePath.getFileName().toString();
            String itemId = fileName.substring(0, fileName.lastIndexOf(46));
            YamlFile yamlFile = new YamlFile(filePath.toAbsolutePath().toString());
            try {
                CustomItemEntry entry;
                class_1799 itemStack;
                List<class_2561> lore;
                class_2561 displayName;
                yamlFile.load();
                String permission = yamlFile.getString("permission");
                if (permission == null) {
                    ServerCosmetics.LOGGER.error("Error loading {}: 'permission' not defined.", (Object)fileName);
                    continue;
                }
                String type = yamlFile.getString("type");
                int sortingPriority = yamlFile.getInt("sortingPriority", 0);
                if (type != null) {
                    String tempName;
                    String namePath = "display-name";
                    String legacyNamePath = itemPropertiesRootNode + ".display-name";
                    String lorePath = "lore";
                    String legacyLorePath = itemPropertiesRootNode + ".lore";
                    String string = tempName = yamlFile.getString(namePath) == null ? yamlFile.getString(legacyNamePath) : yamlFile.getString(namePath);
                    if (tempName == null) {
                        ServerCosmetics.LOGGER.warn("Cosmetic {}: '{}' not defined. Using empty display name.", (Object)fileName, (Object)namePath);
                        displayName = Utils.formatDisplayName("");
                    } else {
                        displayName = Utils.formatDisplayName(tempName);
                    }
                    lore = yamlFile.getStringList(lorePath).stream().map(Utils::formatDisplayName).toList();
                    if (lore.isEmpty() && yamlFile.isList(legacyLorePath)) {
                        lore = yamlFile.getStringList(legacyLorePath).stream().map(Utils::formatDisplayName).toList();
                    }
                } else {
                    String tempName = yamlFile.getString("display-name");
                    if (legacyMode && tempName == null && yamlFile.getString("available-item.display-name") != null) {
                        displayName = Utils.formatDisplayName(yamlFile.getString("available-item.display-name"));
                    } else if (tempName != null) {
                        displayName = Utils.formatDisplayName(tempName);
                    } else {
                        ServerCosmetics.LOGGER.warn("Item Skin {}: 'display-name' not defined. Using empty display name.", (Object)fileName);
                        displayName = Utils.formatDisplayName("");
                    }
                    lore = yamlFile.getStringList("lore").stream().map(Utils::formatDisplayName).toList();
                    if (legacyMode && lore.isEmpty()) {
                        lore = yamlFile.getStringList("available-item.lore").stream().map(Utils::formatDisplayName).toList();
                    }
                }
                if (type != null) {
                    Object baseItemMaterial;
                    String materialPath = "material";
                    String legacyMaterialPath = itemPropertiesRootNode + ".material";
                    if (ItemType.valueOf(type.toUpperCase()) == ItemType.HELMET || ItemType.valueOf(type.toUpperCase()) == ItemType.CHESTPLATE || ItemType.valueOf(type.toUpperCase()) == ItemType.LEGGINGS || ItemType.valueOf(type.toUpperCase()) == ItemType.BOOTS) {
                        baseItemMaterial = "leather_" + type.toLowerCase();
                    } else {
                        Object object = baseItemMaterial = yamlFile.getString(materialPath) == null ? yamlFile.getString(legacyMaterialPath) : yamlFile.getString(materialPath);
                        if (baseItemMaterial == null) {
                            ServerCosmetics.LOGGER.error("Error loading cosmetic {}: '{}' not defined, using paper as fallback", (Object)fileName, (Object)materialPath);
                            baseItemMaterial = "minecraft:paper";
                        }
                    }
                    if (!((String)baseItemMaterial).contains(":")) {
                        baseItemMaterial = "minecraft:" + ((String)baseItemMaterial).toLowerCase();
                    }
                    itemStack = CustomItemRegistry.createItemStack((String)baseItemMaterial, displayName, itemId, lore);
                    if (ItemType.valueOf(type.toUpperCase()) == ItemType.BODY_COSMETIC) {
                        PolymerModelData polymerModelData = PolymerResourcePackUtils.requestModel((class_1792)((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)baseItemMaterial))), (class_2960)class_2960.method_60655((String)"servercosmetics", (String)("item/" + itemId + "_sneaking")));
                        isMirrored = yamlFile.getBoolean("isMirrored", false);
                        autoAlignment = yamlFile.getBoolean("autoAlignment", false);
                        offsetWhenSneaking = yamlFile.getBoolean("offsetWhenSneaking", false);
                        autoscale = yamlFile.getBoolean("autoscale", false);
                        entry = new CustomItemEntry(itemId, permission, displayName, lore, itemStack, ItemType.valueOf(type.toUpperCase()), (String)baseItemMaterial, sortingPriority, List.of(Tags.ENTITY, Tags.BODY_COSMETIC), new BodyCosmeticsData(polymerModelData, isMirrored, autoAlignment, offsetWhenSneaking, autoscale));
                    } else if (ItemType.valueOf(type.toUpperCase()) == ItemType.CHESTPLATE_BODY_COSMETIC || ItemType.valueOf(type.toUpperCase()) == ItemType.HAT_BODY_COSMETIC || ItemType.valueOf(type.toUpperCase()) == ItemType.BOOTS_BODY_COSMETIC) {
                        PolymerModelData polymerModelData = PolymerResourcePackUtils.requestModel((class_1792)((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)baseItemMaterial))), (class_2960)class_2960.method_60655((String)"servercosmetics", (String)("item/" + itemId + "_sneaking")));
                        isMirrored = yamlFile.getBoolean("isMirrored", false);
                        autoAlignment = yamlFile.getBoolean("autoAlignment", false);
                        offsetWhenSneaking = yamlFile.getBoolean("offsetWhenSneaking", false);
                        autoscale = yamlFile.getBoolean("autoscale", false);
                        entry = new CustomItemEntry(itemId, permission, displayName, lore, itemStack, ItemType.valueOf(type.toUpperCase()), (String)baseItemMaterial, sortingPriority, List.of(Tags.ENTITY, Tags.ARMOR, Tags.BODY_COSMETIC), new BodyCosmeticsData(polymerModelData, isMirrored, autoAlignment, offsetWhenSneaking, autoscale));
                    } else if (ItemType.valueOf(type.toUpperCase()) == ItemType.HELMET || ItemType.valueOf(type.toUpperCase()) == ItemType.CHESTPLATE || ItemType.valueOf(type.toUpperCase()) == ItemType.LEGGINGS || ItemType.valueOf(type.toUpperCase()) == ItemType.BOOTS) {
                        if (ServerCosmetics.DEV_ENV) {
                            for (int i = 0; i < 20; ++i) {
                                entry = new CustomItemEntry(itemId + i, permission, displayName, lore, itemStack, ItemType.valueOf(type.toUpperCase()), (String)baseItemMaterial, sortingPriority, List.of(Tags.ARMOR, Tags.ITEM), new ArmorCosmeticsData());
                                cosmeticsList.add(entry);
                            }
                        }
                        entry = new CustomItemEntry(itemId, permission, displayName, lore, itemStack, ItemType.valueOf(type.toUpperCase()), (String)baseItemMaterial, sortingPriority, List.of(Tags.ARMOR, Tags.ITEM), new ArmorCosmeticsData());
                    } else {
                        entry = new CustomItemEntry(itemId, permission, displayName, lore, itemStack, ItemType.valueOf(type.toUpperCase()), (String)baseItemMaterial, sortingPriority, List.of(Tags.ITEM), null);
                    }
                    cosmeticsList.add(entry);
                    continue;
                }
                List targetMaterials = yamlFile.getStringList("material");
                if (targetMaterials.isEmpty()) {
                    String singleMaterial = yamlFile.getString("material");
                    if (singleMaterial != null) {
                        targetMaterials.add(singleMaterial);
                    } else {
                        ServerCosmetics.LOGGER.error("Error loading item skin {}: 'material' (list or string) not defined.", (Object)fileName);
                        continue;
                    }
                }
                for (Object materialKey : targetMaterials) {
                    if (!((String)materialKey).contains(":")) {
                        materialKey = "minecraft:" + ((String)materialKey).toLowerCase();
                    }
                    itemStack = CustomItemRegistry.createItemStack((String)materialKey, displayName, itemId, lore);
                    entry = new CustomItemEntry(itemId, permission, displayName, lore, itemStack, ItemType.ITEM_SKIN, (String)materialKey, sortingPriority, new ArrayList<Tags>(), null);
                    cosmeticsList.add(entry);
                }
            }
            catch (Exception e) {
                ServerCosmetics.LOGGER.error("Failed to load custom item from file: {}", (Object)filePath, (Object)e);
            }
        }
    }

    public static class_1799 createItemStack(String baseMaterialId, class_2561 displayName, String cosmeticOrSkinId, List<class_2561> loreTexts) {
        class_1738 armorItem;
        PolymerModelData polymerModel;
        class_1792 baseItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)baseMaterialId));
        if (baseItem == class_7923.field_41178.method_10223(class_7923.field_41178.method_10137()) && !baseMaterialId.equals(class_7923.field_41178.method_10137().toString())) {
            ServerCosmetics.LOGGER.warn("Invalid baseMaterialId '{}' for item '{}'. Defaulting to minecraft:paper.", (Object)baseMaterialId, (Object)cosmeticOrSkinId);
            baseItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)"minecraft:paper"));
        }
        try {
            class_1738 armorItem2;
            if (baseItem instanceof class_1738 && (armorItem2 = (class_1738)baseItem).method_48398() != class_1738.class_8051.field_48838) {
                String armorId = cosmeticOrSkinId.replace("_" + armorItem2.method_48398().method_48400().toLowerCase(), "");
                RuntimeModelManager.requestArmorModel(armorId, armorItem2.method_48398());
                String modelIdPath = "item/armor/" + cosmeticOrSkinId;
                polymerModel = PolymerResourcePackUtils.requestModel((class_1792)CustomItemRegistry.getItemFor(armorItem2.method_48398()), (class_2960)ServerCosmetics.id(modelIdPath));
            } else {
                polymerModel = PolymerResourcePackUtils.requestModel((class_1792)baseItem, (class_2960)class_2960.method_60655((String)"servercosmetics", (String)("item/" + cosmeticOrSkinId)));
            }
        }
        catch (Exception e) {
            ServerCosmetics.LOGGER.error("Failed to request model for item id '{}' with base item '{}': {}", new Object[]{cosmeticOrSkinId, baseMaterialId, e.getMessage()});
            class_1799 errorStack = new class_1799((class_1935)baseItem);
            errorStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("Error: " + cosmeticOrSkinId)));
            return errorStack;
        }
        class_1799 itemStack = new class_1799((class_1935)polymerModel.item());
        itemStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(nbt -> nbt.method_10582("cosmeticItemId", cosmeticOrSkinId)));
        if (baseItem instanceof class_1738 && (armorItem = (class_1738)baseItem).method_48398() != class_1738.class_8051.field_48838) {
            String armorId = cosmeticOrSkinId.replace("_" + armorItem.method_48398().method_48400().toLowerCase(), "");
            PolymerArmorModel armorModel = PolymerResourcePackUtils.requestArmor((class_2960)ServerCosmetics.id(armorId));
            itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(armorModel.color(), true));
        }
        if (loreTexts != null && !loreTexts.isEmpty()) {
            itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(loreTexts));
        } else {
            itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(Collections.emptyList()));
        }
        itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(polymerModel.value()));
        itemStack.method_57379(class_9334.field_49631, (Object)displayName);
        return itemStack;
    }

    private static class_1792 getItemFor(class_1738.class_8051 type) {
        return switch (type) {
            case class_1738.class_8051.field_41934 -> class_1802.field_8267;
            case class_1738.class_8051.field_41935 -> class_1802.field_8577;
            case class_1738.class_8051.field_41936 -> class_1802.field_8570;
            case class_1738.class_8051.field_41937 -> class_1802.field_8370;
            default -> class_1802.field_20391;
        };
    }

    public static CustomItemEntry getCosmetic(String id) {
        CustomItemEntry cosmetic = null;
        for (CustomItemEntry entry : cosmeticsList) {
            if (!entry.id().equals(id)) continue;
            cosmetic = entry;
        }
        return cosmetic;
    }

    public static List<CustomItemEntry> getCosmeticsList() {
        return Collections.unmodifiableList(cosmeticsList);
    }

    public static List<CustomItemEntry> getAllCosmeticsForMaterial(ItemType type, String targetMaterialId) {
        ArrayList<CustomItemEntry> filteredList = new ArrayList<CustomItemEntry>();
        for (CustomItemEntry entry : cosmeticsList) {
            if (entry.type() != type || !entry.baseItemForModel().equals(targetMaterialId)) continue;
            filteredList.add(entry);
        }
        return filteredList;
    }

    public static List<CustomItemEntry> getAllCosmeticsForMaterial(ItemType type, class_1792 item) {
        String targetMaterialId = class_7923.field_41178.method_10221((Object)item).toString();
        return CustomItemRegistry.getAllCosmeticsForMaterial(type, targetMaterialId);
    }

    public static List<CustomItemEntry> getAllCosmeticsForType(ItemType type) {
        ArrayList<CustomItemEntry> filteredList = new ArrayList<CustomItemEntry>();
        for (CustomItemEntry entry : cosmeticsList) {
            if (entry.type() != type) continue;
            filteredList.add(entry);
        }
        return filteredList;
    }

    @Generated
    public static void setLegacyMode(boolean legacyMode) {
        CustomItemRegistry.legacyMode = legacyMode;
    }
}

