/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.datagen;

import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.datagen.ArmorModelGenerator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.class_1738;

public class RuntimeModelManager {
    private static final Map<String, Set<class_1738.class_8051>> requestedModels = new ConcurrentHashMap<String, Set<class_1738.class_8051>>();

    public static void requestArmorModel(String cosmeticId, class_1738.class_8051 type) {
        requestedModels.computeIfAbsent(cosmeticId, k -> ConcurrentHashMap.newKeySet()).add(type);
        ServerCosmetics.LOGGER.debug("Requested runtime model generation for cosmetic '{}' of type {}", (Object)cosmeticId, (Object)type.method_48400());
    }

    public static void generateAndProvideModels(BiConsumer<String, byte[]> provider) {
        if (requestedModels.isEmpty()) {
            return;
        }
        ServerCosmetics.LOGGER.info("Starting runtime generation of {} cosmetic armor model set(s).", (Object)requestedModels.size());
        requestedModels.forEach((cosmeticId, types) -> {
            for (class_1738.class_8051 type : types) {
                Map<String, byte[]> models = ArmorModelGenerator.generateModels(cosmeticId, type);
                models.forEach((path, data) -> {
                    if (provider != null) {
                        provider.accept((String)path, (byte[])data);
                        ServerCosmetics.LOGGER.debug("Provided runtime model: {}", path);
                    }
                });
            }
        });
    }

    public static void clearRequestedModels() {
        requestedModels.clear();
    }
}

