/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.gui;

import com.mojang.brigadier.context.CommandContext;
import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.AbstractGuiConfig;
import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.config.ItemSkinsGUIConfig;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.gui.PagedItemDisplayGui;
import com.zefir.servercosmetics.gui.actions.EquipCosmeticAction;
import com.zefir.servercosmetics.gui.filters.ItemTypeFilter;
import com.zefir.servercosmetics.gui.filters.PermissionFilter;
import com.zefir.servercosmetics.gui.providers.StandaloneCosmeticProvider;
import com.zefir.servercosmetics.util.GUIUtils;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CosmeticsGUI {
    public static int openGui(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can only be run by a player."), false);
            return 1;
        }
        try {
            AbstractGuiConfig config = ConfigManager.COSMETICS_GUI_CONFIG;
            StandaloneCosmeticProvider provider = new StandaloneCosmeticProvider();
            EquipCosmeticAction action = new EquipCosmeticAction();
            PagedItemDisplayGui gui = new PagedItemDisplayGui(player, config, provider, action);
            gui.getFilterManager().addFilter("permission", new PermissionFilter(player), config.getButtonConfig("filter.show-owned-skins-disabled"), config.getButtonConfig("filter.show-owned-skins-enabled"), false);
            gui.getFilterManager().addFilter("hat", new ItemTypeFilter(List.of(ItemType.HAT)), config.getButtonConfig("filter.hats-disabled"), config.getButtonConfig("filter.hats-enabled"), true);
            gui.getFilterManager().addFilter("body-cosmetic", new ItemTypeFilter(List.of(ItemType.BODY_COSMETIC)), config.getButtonConfig("filter.body-cosmetics-disabled"), config.getButtonConfig("filter.body-cosmetics-enabled"), false);
            gui.getFilterManager().addFilter("chestplate", new ItemTypeFilter(List.of(ItemType.HELMET, ItemType.CHESTPLATE, ItemType.LEGGINGS, ItemType.BOOTS, ItemType.HAT_BODY_COSMETIC, ItemType.CHESTPLATE_BODY_COSMETIC, ItemType.LEGGINGS_BODY_COSMETIC, ItemType.BOOTS_BODY_COSMETIC)), config.getButtonConfig("filter.chestplate-cosmetics-disabled"), config.getButtonConfig("filter.chestplate-cosmetics-enabled"), false);
            GUIUtils.setUpButton(gui, config.getButtonConfig("removeSkin"), () -> {
                gui.close();
                for (ItemType type : gui.getFilterManager().getTargetTypes()) {
                    action.execute(player, class_1799.field_8037, type);
                }
            });
            gui.setSlot(ItemSkinsGUIConfig.getItemSlot(), (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8077).setName((class_2561)class_2561.method_43470((String)"Select an Item")).addLoreLine((class_2561)class_2561.method_43470((String)"Click an item in your inventory below.")));
            gui.reinitialize(provider, action);
            gui.open();
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"An error occurred opening the Cosmetics GUI. See console for details."));
            ServerCosmetics.LOGGER.error("Failed to open cosmetics GUI for player {}", (Object)player.method_5477().getString(), (Object)e);
        }
        return 0;
    }
}

