/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.config;

import com.mojang.brigadier.context.CommandContext;
import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.AbstractGuiConfig;
import com.zefir.servercosmetics.config.CosmeticsGUIConfig;
import com.zefir.servercosmetics.config.ItemSkinsGUIConfig;
import com.zefir.servercosmetics.data.BodyCosmeticsData;
import com.zefir.servercosmetics.data.CustomItemEntry;
import com.zefir.servercosmetics.data.CustomItemRegistry;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.datagen.RuntimeModelManager;
import com.zefir.servercosmetics.util.Utils;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.json.JSONArray;
import org.json.JSONObject;
import org.simpleyaml.configuration.comments.format.YamlCommentFormat;
import org.simpleyaml.configuration.file.YamlFile;

public class ConfigManager {
    public static final Path SERVER_COSMETICS_DIR = FabricLoader.getInstance().getConfigDir().resolve("ServerCosmetics");
    private static final String TARGET_TEXTURE_PATH = "assets/servercosmetics/textures/";
    private static final String TARGET_MODEL_PATH = "assets/servercosmetics/models/item/";
    private static String configReloadPermission;
    private static String itemSkinsReloadPermission;
    private static String cosmeticsReloadPermission;
    private static class_2561 successConfigReloadMessage;
    private static class_2561 errorConfigReloadMessage;
    private static boolean legacyMode;
    private static boolean enableExperimentalFeatures;
    public static final AbstractGuiConfig ITEM_SKINS_GUI_CONFIG;
    public static final AbstractGuiConfig COSMETICS_GUI_CONFIG;

    public static void registerConfigs() {
        ConfigManager.createAndLoadMainConfig();
        CustomItemRegistry.setLegacyMode(legacyMode);
        ITEM_SKINS_GUI_CONFIG.init();
        COSMETICS_GUI_CONFIG.init();
        CustomItemRegistry.initialize();
        ConfigManager.registerResourcePackListener();
    }

    public static void registerResourcePackListener() {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(builder -> {
            RuntimeModelManager.generateAndProvideModels((arg_0, arg_1) -> ((ResourcePackBuilder)builder).addData(arg_0, arg_1));
            Path resourcePackSourceDir = SERVER_COSMETICS_DIR.resolve("Assets");
            if (!Files.isDirectory(resourcePackSourceDir, new LinkOption[0])) {
                ServerCosmetics.LOGGER.info("Custom resource source directory not found: {}. Creating it.", (Object)resourcePackSourceDir.toAbsolutePath());
                try {
                    Files.createDirectories(resourcePackSourceDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    ServerCosmetics.LOGGER.error("Failed to create assets directory: {}", (Object)resourcePackSourceDir.toAbsolutePath(), (Object)e);
                }
                return;
            }
            ServerCosmetics.LOGGER.info("Scanning for .png and .json files in: {}", (Object)resourcePackSourceDir.toAbsolutePath());
            try (Stream<Path> pathStream = Files.walk(resourcePackSourceDir, new FileVisitOption[0]);){
                pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(filePath -> ConfigManager.processResourcePackFile(filePath, builder));
            }
            catch (IOException e) {
                ServerCosmetics.LOGGER.error("Error walking directory {} for resource pack generation", (Object)resourcePackSourceDir.toAbsolutePath(), (Object)e);
            }
        });
    }

    private static void processResourcePackFile(Path filePath, ResourcePackBuilder builder) {
        Path fileNamePath = filePath.getFileName();
        if (fileNamePath == null) {
            return;
        }
        String fileName = fileNamePath.toString();
        String fileNameLower = fileName.toLowerCase(Locale.ROOT);
        try {
            byte[] data = Files.readAllBytes(filePath);
            if (fileNameLower.endsWith(".png")) {
                ConfigManager.processPngFile(builder, fileName, fileNameLower, data);
            } else if (fileNameLower.endsWith(".json")) {
                ConfigManager.processJsonFile(builder, fileName, fileNameLower, data);
            } else if (fileNameLower.endsWith(".mcmeta")) {
                ConfigManager.processMcmetaFile(builder, fileName, data);
            }
        }
        catch (IOException e) {
            ServerCosmetics.LOGGER.error("Failed to read file {} for resource pack", (Object)filePath, (Object)e);
        }
    }

    private static void processPngFile(ResourcePackBuilder builder, String fileName, String fileNameLower, byte[] data) {
        String targetBaseDir = fileNameLower.endsWith("_helmet.png") || fileNameLower.endsWith("_chestplate.png") || fileNameLower.endsWith("_leggings.png") || fileNameLower.endsWith("_boots.png") ? "assets/servercosmetics/textures/item/armor/" : (fileNameLower.endsWith("_layer_1.png") || fileNameLower.endsWith("_layer_2.png") ? "assets/servercosmetics/textures/models/armor/" : "assets/servercosmetics/textures/item/");
        ConfigManager.addData(builder, targetBaseDir + fileName, fileName, data);
    }

    private static void processMcmetaFile(ResourcePackBuilder builder, String fileName, byte[] data) {
        ServerCosmetics.LOGGER.debug("MCMETA file {} found, targeting TEXTURE_PATH.", (Object)fileName);
        String targetBaseDir = "assets/servercosmetics/textures/item/";
        ConfigManager.addData(builder, targetBaseDir + fileName, fileName, data);
    }

    private static void processJsonFile(ResourcePackBuilder builder, String fileName, String fileNameLower, byte[] data) {
        ItemType type;
        String cosmeticId = fileNameLower.substring(0, fileNameLower.lastIndexOf(46));
        CustomItemEntry cosmeticEntry = CustomItemRegistry.getCosmetic(cosmeticId);
        if (cosmeticEntry != null && ((type = cosmeticEntry.type()) == ItemType.BODY_COSMETIC || type == ItemType.CHESTPLATE_BODY_COSMETIC || type == ItemType.LEGGINGS_BODY_COSMETIC || type == ItemType.BOOTS_BODY_COSMETIC)) {
            String content = new String(data, StandardCharsets.UTF_8);
            JSONObject jsonObject = new JSONObject(content);
            ConfigManager.handleBodyCosmeticJson(builder, jsonObject, fileName, cosmeticEntry);
            return;
        }
        String targetPath = TARGET_MODEL_PATH + fileName;
        ConfigManager.addData(builder, targetPath, fileName, data);
    }

    private static void handleBodyCosmeticJson(ResourcePackBuilder builder, JSONObject originalJson, String fileName, CustomItemEntry entry) {
        List<Number> sneakingTranslation;
        List<Number> normalTranslation;
        List<Number> scale;
        List<Number> normalRotation;
        block6: {
            block5: {
                ItemType type = entry.type();
                String targetBaseDir = TARGET_MODEL_PATH;
                normalRotation = ((BodyCosmeticsData)entry.cosmeticData()).mirrored() ? Arrays.asList(0, -180, 0) : null;
                scale = Arrays.asList(1.45, 1.45, 1.45);
                if (!((BodyCosmeticsData)entry.cosmeticData()).autoAlignment()) break block5;
                switch (type) {
                    case BODY_COSMETIC: 
                    case CHESTPLATE_BODY_COSMETIC: {
                        normalTranslation = Arrays.asList(0, -56.5, 2.15);
                        sneakingTranslation = Arrays.asList(0, -56.5, 4.15);
                        break block6;
                    }
                    case LEGGINGS_BODY_COSMETIC: {
                        normalTranslation = Arrays.asList(0, -69.25, 2.15);
                        sneakingTranslation = Arrays.asList(0, -65, 8.15);
                        break block6;
                    }
                    case BOOTS_BODY_COSMETIC: {
                        normalTranslation = Arrays.asList(0, -79.25, 2.15);
                        sneakingTranslation = Arrays.asList(0, -75, 8.15);
                        break block6;
                    }
                    default: {
                        ServerCosmetics.LOGGER.warn("Unhandled cosmetic type {} in handleBodyCosmeticJson.", (Object)type);
                        return;
                    }
                }
            }
            normalTranslation = null;
            sneakingTranslation = null;
        }
        JSONObject jsonSneaking = new JSONObject(originalJson.toString());
        ConfigManager.addHeadDisplay(originalJson, normalRotation, normalTranslation, scale);
        byte[] normalData = originalJson.toString().getBytes(StandardCharsets.UTF_8);
        ConfigManager.addData(builder, TARGET_MODEL_PATH + fileName, fileName, normalData);
        String sneakingFileName = fileName.replace(".json", "_sneaking.json");
        ConfigManager.addHeadDisplay(jsonSneaking, normalRotation, sneakingTranslation, scale);
        byte[] sneakingData = jsonSneaking.toString().getBytes(StandardCharsets.UTF_8);
        ConfigManager.addData(builder, TARGET_MODEL_PATH + sneakingFileName, sneakingFileName, sneakingData);
    }

    private static void addHeadDisplay(JSONObject parentJson, List<Number> rotation, List<Number> translation, List<Number> scale) {
        JSONObject displayObject = parentJson.optJSONObject("display");
        if (displayObject == null) {
            displayObject = new JSONObject();
            parentJson.put("display", (Object)displayObject);
        }
        JSONObject head = new JSONObject();
        if (rotation != null) {
            head.put("rotation", (Object)new JSONArray(rotation));
        }
        if (translation != null) {
            head.put("translation", (Object)new JSONArray(translation));
        }
        if (scale != null) {
            head.put("scale", (Object)new JSONArray(scale));
        }
        if (!head.isEmpty()) {
            displayObject.put("head", (Object)head);
        }
    }

    private static void addData(ResourcePackBuilder builder, String path, String fileName, byte[] data) {
        if (builder.addData(path, data)) {
            ServerCosmetics.LOGGER.debug("Added {} -> {}", (Object)fileName, (Object)path);
        } else {
            ServerCosmetics.LOGGER.warn("Could not add {} as {} to resource pack (maybe already exists?)", (Object)fileName, (Object)path);
        }
    }

    public static void loadDemoConfigs() {
        if (SERVER_COSMETICS_DIR.toFile().exists() && SERVER_COSMETICS_DIR.resolve("config.yml").toFile().exists()) {
            return;
        }
        try {
            Files.createDirectories(SERVER_COSMETICS_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            ServerCosmetics.LOGGER.error("Failed to create base ServerCosmetics directory.", (Throwable)e);
        }
        Path demoConfigsPathSource = FabricLoader.getInstance().getModContainer("servercosmetics").flatMap(modContainer -> modContainer.findPath("assets/servercosmetics/demo-configs/")).orElse(null);
        if (demoConfigsPathSource == null) {
            ServerCosmetics.LOGGER.warn("Could not find demo-configs path in mod assets.");
            return;
        }
        ServerCosmetics.LOGGER.info("Loading demo configurations from {} to {}", (Object)demoConfigsPathSource, (Object)SERVER_COSMETICS_DIR);
        try (Stream<Path> stream = Files.walk(demoConfigsPathSource, new FileVisitOption[0]);){
            stream.forEach(sourcePath -> {
                Path destPath = SERVER_COSMETICS_DIR.resolve(demoConfigsPathSource.relativize((Path)sourcePath).toString());
                try {
                    if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                        if (Files.notExists(destPath, new LinkOption[0])) {
                            Files.createDirectories(destPath, new FileAttribute[0]);
                        }
                    } else {
                        Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to copy demo file " + String.valueOf(sourcePath) + " to " + String.valueOf(destPath), e);
                }
            });
        }
        catch (IOException | RuntimeException e) {
            ServerCosmetics.LOGGER.error("Failed to load demo configs fully.", (Throwable)e);
        }
    }

    public static int reloadAllConfigsCommand(CommandContext<class_2168> context) {
        try {
            ConfigManager.createAndLoadMainConfig();
            CustomItemRegistry.setLegacyMode(legacyMode);
            ITEM_SKINS_GUI_CONFIG.init();
            COSMETICS_GUI_CONFIG.init();
            CustomItemRegistry.reloadAll();
            ((class_2168)context.getSource()).method_9226(() -> successConfigReloadMessage, false);
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> errorConfigReloadMessage, false);
            ServerCosmetics.LOGGER.error("An error occurred during ALL configs reload!", (Throwable)e);
        }
        return 1;
    }

    public static int reloadItemSkinsConfigsCommand(CommandContext<class_2168> context) {
        try {
            ConfigManager.createAndLoadMainConfig();
            CustomItemRegistry.setLegacyMode(legacyMode);
            ITEM_SKINS_GUI_CONFIG.init();
            CustomItemRegistry.reloadItemSkins();
            ((class_2168)context.getSource()).method_9226(() -> successConfigReloadMessage, false);
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> errorConfigReloadMessage, false);
            ServerCosmetics.LOGGER.error("An error occurred during ItemSkins configs reload!", (Throwable)e);
        }
        return 1;
    }

    public static int reloadCosmeticsConfigsCommand(CommandContext<class_2168> context) {
        try {
            ConfigManager.createAndLoadMainConfig();
            CustomItemRegistry.setLegacyMode(legacyMode);
            COSMETICS_GUI_CONFIG.init();
            CustomItemRegistry.reloadCosmetics();
            ((class_2168)context.getSource()).method_9226(() -> successConfigReloadMessage, false);
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> errorConfigReloadMessage, false);
            ServerCosmetics.LOGGER.error("An error occurred during Cosmetics configs reload!", (Throwable)e);
        }
        return 1;
    }

    private static void createAndLoadMainConfig() {
        ConfigManager.loadDemoConfigs();
        Path configFile = SERVER_COSMETICS_DIR.resolve("config.yml");
        YamlFile yamlFile = new YamlFile(configFile.toAbsolutePath().toString());
        try {
            yamlFile.createOrLoadWithComments();
            ConfigManager.initializeMainConfigDefaults(yamlFile);
            yamlFile.loadWithComments();
            configReloadPermission = yamlFile.getString("permissions.reloadAllConfigs");
            itemSkinsReloadPermission = yamlFile.getString("permissions.reloadItemSkins");
            cosmeticsReloadPermission = yamlFile.getString("permissions.reloadCosmetics");
            enableExperimentalFeatures = yamlFile.getBoolean("enableExperimentalFeatures", false);
            successConfigReloadMessage = Utils.formatDisplayName(yamlFile.getString("configReload.message.success"));
            errorConfigReloadMessage = Utils.formatDisplayName(yamlFile.getString("configReload.message.error"));
            legacyMode = yamlFile.getBoolean("legacyMode");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create or load main configuration file (config.yml)", e);
        }
    }

    private static void initializeMainConfigDefaults(YamlFile yamlFile) {
        yamlFile.setCommentFormat(YamlCommentFormat.PRETTY);
        yamlFile.options().headerFormatter().prefixFirst("######################").commentPrefix("## ").commentSuffix(" ##").suffixLast("######################");
        yamlFile.setHeader("Main Config File");
        yamlFile.addDefault("debug", (Object)false);
        yamlFile.addDefault("permissions.reloadAllConfigs", (Object)"servercosmetics.reload");
        yamlFile.addDefault("permissions.reloadItemSkins", (Object)"servercosmetics.reload.itemskins");
        yamlFile.addDefault("permissions.reloadCosmetics", (Object)"servercosmetics.reload.cosmetics");
        yamlFile.path("permissions").comment("If the mod cannot get permissions from config, the default one will be used");
        yamlFile.addDefault("configReload.message.success", (Object)"&aConfig successfully reload!");
        yamlFile.addDefault("configReload.message.error", (Object)"&cAn error occurred during configs reload!");
        yamlFile.addDefault("enableExperimentalFeatures", (Object)false);
        yamlFile.path("legacyMode").addDefault((Object)false).commentSide("If true, plugin will try to read some fields from older config structures for cosmetic/skin definitions. Recommended: false for new setups.");
        try {
            yamlFile.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save default main yml configuration", e);
        }
    }

    @Generated
    public static String getConfigReloadPermission() {
        return configReloadPermission;
    }

    @Generated
    public static String getItemSkinsReloadPermission() {
        return itemSkinsReloadPermission;
    }

    @Generated
    public static String getCosmeticsReloadPermission() {
        return cosmeticsReloadPermission;
    }

    @Generated
    public static boolean isEnableExperimentalFeatures() {
        return enableExperimentalFeatures;
    }

    static {
        ITEM_SKINS_GUI_CONFIG = new ItemSkinsGUIConfig();
        COSMETICS_GUI_CONFIG = new CosmeticsGUIConfig();
    }

    public record NavigationButton(class_2561 name, class_1792 baseItem, PolymerModelData polymerModelData, int slotIndex, List<String> lore) {
    }
}

