/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.gui;

import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.config.CosmeticsGUIConfig;
import com.zefir.servercosmetics.gui.resources.GuiTextures;
import com.zefir.servercosmetics.util.GUIUtils;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SignGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class ColorPickerComponent {
    private final class_3222 player;
    private final class_1799 itemToColor;
    private final Consumer<class_1799> onColorSelectCallback;

    public ColorPickerComponent(class_3222 player, class_1799 itemToColor, Consumer<class_1799> onColorSelectCallback) {
        this.player = player;
        this.itemToColor = itemToColor.method_7972();
        this.onColorSelectCallback = onColorSelectCallback;
    }

    public void open() {
        try {
            new ColorPickerScreen(this.player, this.itemToColor, this.onColorSelectCallback).open();
        }
        catch (Exception e) {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"Error opening color picker."), false);
            ServerCosmetics.LOGGER.error("Failed to open ColorPickerComponent", (Throwable)e);
        }
    }

    private static class ColorPickerScreen
    extends SimpleGui {
        private final class_3222 player;
        private final class_1799 hatItemStack;
        private final Consumer<class_1799> onColorSelectCallback;
        private final MutableFloat saturation = new MutableFloat(100.0f);
        private final MutableInt selectedBaseColorSlotIndex = new MutableInt(0);
        private final MutableBoolean usePaintBrushView = new MutableBoolean(true);
        private boolean initialGradientDrawn = false;

        public ColorPickerScreen(class_3222 player, class_1799 hatItemStack, Consumer<class_1799> onColorSelectCallback) {
            super(class_3917.field_18667, player, true);
            this.player = player;
            this.hatItemStack = hatItemStack.method_7972();
            this.onColorSelectCallback = onColorSelectCallback;
            this.setTitle(GuiTextures.COLOR_PICKER_MENU.apply(CosmeticsGUIConfig.getColorPickerGUIName()));
            this.populateGui();
        }

        private void populateGui() {
            this.setSlot(CosmeticsGUIConfig.getColorInputSlot(), (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)this.hatItemStack));
            this.drawBaseColorSlots();
            if (!this.initialGradientDrawn && CosmeticsGUIConfig.getColorSlots().length > 0) {
                this.selectedBaseColorSlotIndex.setValue(CosmeticsGUIConfig.getColorSlots()[0]);
                this.drawGradientSlots();
                this.initialGradientDrawn = true;
            }
            this.setupBrightnessButtons();
            this.setupViewToggleButtons();
            this.setupColorInputButton();
        }

        public void drawBaseColorSlots() {
            class_1799 templateStack;
            if (this.usePaintBrushView.getValue().booleanValue() && CosmeticsGUIConfig.getPaintItemPolymerModelData() != null) {
                templateStack = new class_1799((class_1935)class_1802.field_18138);
                templateStack.method_57379(class_9334.field_49637, (Object)new class_9280(CosmeticsGUIConfig.getPaintItemPolymerModelData().value()));
            } else {
                templateStack = this.hatItemStack.method_7972();
                templateStack.method_57381(class_9334.field_49644);
            }
            int[] baseColorDisplaySlots = CosmeticsGUIConfig.getColorSlots();
            String[] colorHexValues = CosmeticsGUIConfig.getColorHexValues();
            for (int i = 0; i < baseColorDisplaySlots.length && i < colorHexValues.length; ++i) {
                class_1799 displayColorStack = templateStack.method_7972();
                try {
                    int decimalColor = Integer.parseInt(colorHexValues[i], 16);
                    displayColorStack.method_57379(class_9334.field_49644, (Object)new class_9282(decimalColor, true));
                    class_2487 nbt = new class_2487();
                    nbt.method_10569("baseColorHexIndex", i);
                    displayColorStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
                    int finalI = i;
                    this.setSlot(baseColorDisplaySlots[i], (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)displayColorStack).setCallback((clickIndex, clickType, actionType) -> {
                        this.selectedBaseColorSlotIndex.setValue(finalI);
                        this.drawGradientSlots();
                    }));
                    continue;
                }
                catch (NumberFormatException e) {
                    ServerCosmetics.LOGGER.warn("Invalid hex color in config: {}", (Object)colorHexValues[i]);
                }
            }
            if (!this.initialGradientDrawn && baseColorDisplaySlots.length > 0) {
                this.selectedBaseColorSlotIndex.setValue(0);
                this.drawGradientSlots();
                this.initialGradientDrawn = true;
            }
        }

        private void drawGradientSlots() {
            class_1799 gradientItem;
            Color baseColor;
            if (this.selectedBaseColorSlotIndex.getValue() < 0 || this.selectedBaseColorSlotIndex.getValue() >= CosmeticsGUIConfig.getColorHexValues().length) {
                return;
            }
            String baseHex = CosmeticsGUIConfig.getColorHexValues()[this.selectedBaseColorSlotIndex.getValue()];
            try {
                baseColor = new Color(Integer.parseInt(baseHex, 16));
            }
            catch (NumberFormatException e) {
                ServerCosmetics.LOGGER.warn("Invalid base hex for gradient: {}", (Object)baseHex);
                return;
            }
            if (this.usePaintBrushView.getValue().booleanValue()) {
                gradientItem = new class_1799((class_1935)class_1802.field_18138);
                gradientItem.method_57379(class_9334.field_49637, (Object)new class_9280(CosmeticsGUIConfig.getPaintItemPolymerModelData().value()));
            } else {
                gradientItem = this.hatItemStack.method_7972();
            }
            float[] hsv = Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), null);
            int[] gradientDisplaySlots = CosmeticsGUIConfig.getColorGradientSlots();
            for (int j = 0; j < gradientDisplaySlots.length; ++j) {
                float brightnessFactor = 1.0f / (float)(gradientDisplaySlots.length + 1) * ((float)j + 1.0f);
                brightnessFactor = Math.min(Math.max(brightnessFactor, 0.1f), 1.0f);
                Color gradientStepColor = baseColor.getRed() == baseColor.getGreen() && baseColor.getRed() == baseColor.getBlue() ? new Color(Color.HSBtoRGB(hsv[0], 0.0f, brightnessFactor)) : new Color(Color.HSBtoRGB(hsv[0], this.saturation.getValue().floatValue() / 100.0f, brightnessFactor));
                int stepColorRgb = gradientStepColor.getRGB();
                gradientItem.method_57379(class_9334.field_49644, (Object)new class_9282(stepColorRgb, true));
                this.setSlot(gradientDisplaySlots[j], GuiElementBuilder.from((class_1799)gradientItem).setCallback(() -> {
                    class_1799 finalColoredHat = this.hatItemStack.method_7972();
                    finalColoredHat.method_57379(class_9334.field_49644, (Object)new class_9282(stepColorRgb, true));
                    this.setSlot(CosmeticsGUIConfig.getColorOutputSlot(), GuiElementBuilder.from((class_1799)finalColoredHat.method_7972()).setName((class_2561)class_2561.method_43470((String)"Click to Confirm")).setCallback(() -> {
                        this.close();
                        this.onColorSelectCallback.accept(finalColoredHat);
                    }));
                }));
            }
        }

        public void setupBrightnessButtons() {
            GUIUtils.setUpButton(this, ConfigManager.COSMETICS_GUI_CONFIG.getButtonConfig("decreaseBrightness"), () -> {
                this.saturation.subtract(CosmeticsGUIConfig.getSaturationAdjustmentValue());
                if (this.saturation.getValue().floatValue() < 15.0f) {
                    this.saturation.setValue(15.0f);
                }
                this.drawGradientSlots();
            });
            GUIUtils.setUpButton(this, ConfigManager.COSMETICS_GUI_CONFIG.getButtonConfig("increaseBrightness"), () -> {
                this.saturation.add(CosmeticsGUIConfig.getSaturationAdjustmentValue());
                if (this.saturation.getValue().floatValue() > 100.0f) {
                    this.saturation.setValue(100.0f);
                }
                this.drawGradientSlots();
            });
        }

        public void setupViewToggleButtons() {
            GUIUtils.setUpButton(this, ConfigManager.COSMETICS_GUI_CONFIG.getButtonConfig("toggleColorView"), () -> {
                this.usePaintBrushView.setValue(this.usePaintBrushView.getValue() == false);
                this.drawBaseColorSlots();
            });
        }

        public void setupColorInputButton() {
            GUIUtils.setUpButton(this, ConfigManager.COSMETICS_GUI_CONFIG.getButtonConfig("enterColor"), () -> new ColorInputSign(this.player, this.hatItemStack, this.onColorSelectCallback).open());
        }
    }

    private static class ColorInputSign
    extends SignGui {
        private final class_1799 itemToColor;
        private final Consumer<class_1799> onColorSelectCallback;

        public ColorInputSign(class_3222 player, class_1799 itemToColor, Consumer<class_1799> onColorSelectCallback) {
            super(player);
            this.itemToColor = itemToColor;
            this.onColorSelectCallback = onColorSelectCallback;
            this.setSignType((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)CosmeticsGUIConfig.getSignType())));
            this.setColor(CosmeticsGUIConfig.getSignColor());
            List<String> lines = CosmeticsGUIConfig.getTextLines();
            for (int i = 0; i < lines.size() && i < 4; ++i) {
                this.setLine(i, (class_2561)class_2561.method_43470((String)lines.get(i)));
            }
        }

        public void onClose() {
            Object colorString = this.getLine(0).getString().trim();
            if (((String)colorString).isEmpty()) {
                return;
            }
            try {
                if (((String)colorString).length() == 6 && !((String)colorString).startsWith("#")) {
                    colorString = "#" + (String)colorString;
                }
                Color color = Color.decode((String)colorString);
                class_1799 coloredStack = this.itemToColor.method_7972();
                coloredStack.method_57379(class_9334.field_49644, (Object)new class_9282(color.getRGB(), true));
                this.player.method_7353(CosmeticsGUIConfig.getSuccessColorChangeMessage(), false);
                this.onColorSelectCallback.accept(coloredStack);
            }
            catch (NumberFormatException e) {
                this.player.method_7353(CosmeticsGUIConfig.getErrorColorChangeMessage(), false);
            }
        }
    }
}

