/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.gui;

import com.mojang.brigadier.context.CommandContext;
import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.config.AbstractGuiConfig;
import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.config.ItemSkinsGUIConfig;
import com.zefir.servercosmetics.gui.PagedItemDisplayGui;
import com.zefir.servercosmetics.gui.actions.ApplySkinAction;
import com.zefir.servercosmetics.gui.filters.PermissionFilter;
import com.zefir.servercosmetics.gui.providers.ItemSkinProvider;
import com.zefir.servercosmetics.util.GUIUtils;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ItemSkinsGUI {
    public static int openItemSkinsGui(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"This command can only be run by a player."), false);
            return 1;
        }
        try {
            class_1799 handStack = player.method_6047();
            AbstractGuiConfig config = ConfigManager.ITEM_SKINS_GUI_CONFIG;
            ItemSkinProvider provider = new ItemSkinProvider(handStack.method_7909());
            ApplySkinAction action = new ApplySkinAction(handStack, ItemSkinsGUIConfig.getItemSlot());
            PagedItemDisplayGui gui = new PagedItemDisplayGui(player, config, provider, action){

                public boolean onAnyClick(int idx, ClickType ct, class_1713 sa) {
                    class_1799 newClicked;
                    if (idx >= this.getVirtualSize() && !(newClicked = this.player.field_7512.method_7611(idx).method_7677()).method_7960()) {
                        GuiHelpers.sendPlayerScreenHandler((class_3222)this.player);
                        ItemSkinProvider newProvider = new ItemSkinProvider(newClicked.method_7909());
                        ApplySkinAction newAction = new ApplySkinAction(newClicked, ItemSkinsGUIConfig.getItemSlot());
                        this.reinitialize(newProvider, newAction);
                        ItemSkinsGUI.setupDynamicSlots(this, newClicked);
                    }
                    return super.onAnyClick(idx, ct, sa);
                }
            };
            gui.getFilterManager().addFilter("permission", new PermissionFilter(player), config.getButtonConfig("filter.show-all-skins"), config.getButtonConfig("filter.show-owned-skins"), false);
            gui.setSlot(ItemSkinsGUIConfig.getItemSlot(), (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8077).setName((class_2561)class_2561.method_43470((String)"Select an Item")).addLoreLine((class_2561)class_2561.method_43470((String)"Click an item in your inventory below.")));
            ItemSkinsGUI.setupDynamicSlots(gui, handStack);
            gui.reinitialize(provider, action);
            gui.setLockPlayerInventory(true);
            gui.open();
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"An error occurred opening the Item Skins GUI. See console for details."));
            ServerCosmetics.LOGGER.error("Failed to open item skins GUI for player {}", (Object)player.method_5477().getString(), (Object)e);
        }
        return 0;
    }

    private static void setupDynamicSlots(PagedItemDisplayGui gui, class_1799 targetStack) {
        gui.setSlot(ItemSkinsGUIConfig.getItemSlot(), targetStack.method_7972());
        GUIUtils.setUpButton(gui, ConfigManager.ITEM_SKINS_GUI_CONFIG.getButtonConfig("removeSkin"), () -> {
            targetStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(nbt -> nbt.method_10551("cosmeticItemId")));
            targetStack.method_57381(class_9334.field_49637);
            gui.setSlot(ItemSkinsGUIConfig.getItemSlot(), targetStack.method_7972());
        });
    }
}

