/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.gui;

import com.zefir.servercosmetics.config.AbstractGuiConfig;
import com.zefir.servercosmetics.data.CustomItemEntry;
import com.zefir.servercosmetics.gui.actions.OpenColorPickerAction;
import com.zefir.servercosmetics.gui.core.ICosmeticProvider;
import com.zefir.servercosmetics.gui.core.IItemAction;
import com.zefir.servercosmetics.gui.filters.FilterManager;
import com.zefir.servercosmetics.util.GUIUtils;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class PagedItemDisplayGui
extends SimpleGui {
    private ICosmeticProvider provider;
    private IItemAction defaultClickAction;
    private final AbstractGuiConfig guiConfig;
    private int currentPage = 0;
    private final FilterManager filterManager;

    public PagedItemDisplayGui(class_3222 player, AbstractGuiConfig config, ICosmeticProvider provider, IItemAction defaultClickAction) {
        super(config.getScreenHandlerType(), player, config.isReplaceInventory());
        this.guiConfig = config;
        this.provider = provider;
        this.defaultClickAction = defaultClickAction;
        this.filterManager = new FilterManager(this);
        this.setTitle(config.getGuiName());
        this.populateGui();
    }

    public void reinitialize(ICosmeticProvider newProvider, IItemAction newAction) {
        this.provider = newProvider;
        this.defaultClickAction = newAction;
        this.currentPage = 0;
        this.populateGui();
    }

    public void populateGui() {
        List<CustomItemEntry> allItems = this.provider.getItems();
        Predicate<CustomItemEntry> combinedFilter = this.filterManager.getCombinedPredicate();
        List<CustomItemEntry> filteredItems = allItems.stream().filter(combinedFilter).sorted(Comparator.comparing(CustomItemEntry::id)).collect(Collectors.toList());
        this.drawItems(filteredItems);
        this.setupNavigation(filteredItems.size());
        this.filterManager.drawFilterButtons();
    }

    private void drawItems(List<CustomItemEntry> itemsToDisplay) {
        int[] displaySlots = this.guiConfig.getDisplaySlots();
        int itemsPerPage = displaySlots.length;
        int startIndex = this.currentPage * itemsPerPage;
        for (int i = 0; i < itemsPerPage; ++i) {
            int itemIndex = startIndex + i;
            int slot = displaySlots[i];
            if (itemIndex < itemsToDisplay.size()) {
                CustomItemEntry entry = itemsToDisplay.get(itemIndex);
                class_1799 displayStack = entry.itemStack().method_7972();
                GuiElementBuilder element = new GuiElementBuilder(displayStack);
                if (Permissions.check((class_1297)this.player, (String)entry.permission(), (int)4)) {
                    element.addLoreLine(this.guiConfig.getMessageUnlocked());
                    element.setCallback(() -> this.determineAction(entry).execute(this.player, entry, this));
                } else {
                    element.addLoreLine(this.guiConfig.getMessageLocked());
                }
                this.setSlot(slot, (GuiElementBuilderInterface)element);
                continue;
            }
            this.clearSlot(slot);
        }
    }

    private IItemAction determineAction(CustomItemEntry entry) {
        class_1792 baseItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)entry.baseItemForModel()));
        if (class_1802.field_18138.equals(baseItem)) {
            return new OpenColorPickerAction();
        }
        return this.defaultClickAction;
    }

    private void setupNavigation(int totalFilteredItems) {
        int itemsPerPage = this.guiConfig.getDisplaySlots().length;
        if ((this.currentPage + 1) * itemsPerPage < totalFilteredItems) {
            GUIUtils.setUpButton(this, this.guiConfig.getButtonConfig("next"), () -> {
                ++this.currentPage;
                this.populateGui();
            });
        }
        if (this.currentPage > 0) {
            GUIUtils.setUpButton(this, this.guiConfig.getButtonConfig("previous"), () -> {
                --this.currentPage;
                this.populateGui();
            });
        }
    }

    public void onFilterStateChanged() {
        this.currentPage = 0;
        this.populateGui();
    }

    @Generated
    public FilterManager getFilterManager() {
        return this.filterManager;
    }
}

