/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.gui.filters;

import com.zefir.servercosmetics.config.ConfigManager;
import com.zefir.servercosmetics.data.CustomItemEntry;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.gui.PagedItemDisplayGui;
import com.zefir.servercosmetics.gui.filters.ItemTypeFilter;
import com.zefir.servercosmetics.util.GUIUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;

public class FilterManager {
    private final PagedItemDisplayGui gui;
    private final Map<String, FilterRegistration> registeredFilters = new HashMap<String, FilterRegistration>();
    private final Map<String, Boolean> activeStates = new HashMap<String, Boolean>();
    private ItemType targetType;

    public FilterManager(PagedItemDisplayGui gui) {
        this.gui = gui;
    }

    public void addFilter(String key, Predicate<CustomItemEntry> filter, ConfigManager.NavigationButton inactiveButton, ConfigManager.NavigationButton activeButton, boolean initiallyActive) {
        this.registeredFilters.put(key, new FilterRegistration(filter, inactiveButton, activeButton));
        this.activeStates.put(key, initiallyActive);
    }

    private void disableOtherItemTypeFilters(String key) {
        for (Map.Entry<String, FilterRegistration> entry : this.registeredFilters.entrySet()) {
            if (!(entry.getValue().filter() instanceof ItemTypeFilter) || entry.getKey().equals(key)) continue;
            this.activeStates.put(entry.getKey(), false);
        }
    }

    public Predicate<CustomItemEntry> getCombinedPredicate() {
        return entry -> this.registeredFilters.entrySet().stream().filter(mapEntry -> this.activeStates.getOrDefault(mapEntry.getKey(), false)).allMatch(mapEntry -> ((FilterRegistration)mapEntry.getValue()).filter().test((CustomItemEntry)entry));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawFilterButtons() {
        Iterator<Map.Entry<String, FilterRegistration>> iterator = this.registeredFilters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FilterRegistration> entry = iterator.next();
            String key = entry.getKey();
            FilterRegistration reg = entry.getValue();
            boolean isActive = this.activeStates.getOrDefault(key, false);
            ConfigManager.NavigationButton button = isActive ? reg.inactiveButton : reg.activeButton;
            Predicate<CustomItemEntry> predicate = this.registeredFilters.get(key).filter();
            if (predicate instanceof ItemTypeFilter) {
                ItemTypeFilter itemTypeFilter = (ItemTypeFilter)predicate;
                try {
                    ItemType itemType;
                    ItemType type = itemType = itemTypeFilter.type();
                    if (isActive) {
                        this.targetType = type;
                    }
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            GUIUtils.setUpButton(this.gui, button, () -> {
                Predicate<CustomItemEntry> patt1$temp = this.registeredFilters.get(key).filter();
                if (patt1$temp instanceof ItemTypeFilter) {
                    ItemTypeFilter $b$0 = (ItemTypeFilter)patt1$temp;
                    try {
                        ItemType patt2$temp;
                        ItemType type = patt2$temp = $b$0.type();
                        if (isActive) {
                            return;
                        }
                        this.targetType = type;
                        this.disableOtherItemTypeFilters(key);
                        this.activeStates.put(key, true);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                } else {
                    this.activeStates.put(key, !isActive);
                }
                this.gui.onFilterStateChanged();
            });
        }
        return;
    }

    @Generated
    public ItemType getTargetType() {
        return this.targetType;
    }

    private record FilterRegistration(Predicate<CustomItemEntry> filter, ConfigManager.NavigationButton activeButton, ConfigManager.NavigationButton inactiveButton) {
    }
}

