/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.util;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.zefir.servercosmetics.ServerCosmetics;
import com.zefir.servercosmetics.data.CustomItemEntry;
import com.zefir.servercosmetics.data.CustomItemRegistry;
import com.zefir.servercosmetics.data.ItemType;
import com.zefir.servercosmetics.ext.IItemStack;
import com.zefir.servercosmetics.gui.ColorPickerComponent;
import com.zefir.servercosmetics.gui.actions.EquipCosmeticAction;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public class Utils {
    public static final LegacyComponentSerializer SERIALIZER = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().tags(StandardTags.defaults()).build();

    public static class_2561 formatDisplayName(String st) {
        StringBuilder sb = new StringBuilder(st.length());
        for (int i = 0; i < st.length(); ++i) {
            char nextChar;
            char ch = st.charAt(i);
            if (ch == '\\' && i < st.length() - 1 && (nextChar = st.charAt(i + 1)) == 'u') {
                String hex = st.substring(i + 2, i + 6);
                ch = (char)Integer.parseInt(hex, 16);
                i += 5;
            }
            sb.append(ch);
        }
        String sf = sb.toString().replace("\u00a7", "&");
        String formatted = LegacyComponentSerializer.legacySection().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(SERIALIZER.serialize(MINI_MESSAGE.deserialize((Object)sf))));
        return class_2561.method_30163((String)formatted);
    }

    public static int wearCosmeticById(CommandContext<class_2168> context) {
        class_3222 player;
        try {
            player = class_2186.method_9315(context, (String)"player");
        }
        catch (CommandSyntaxException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid player specified."));
            return 1;
        }
        String id = StringArgumentType.getString(context, (String)"cosmeticId");
        if (id == null || id.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid cosmetic ID."));
            return 1;
        }
        CustomItemEntry entry = CustomItemRegistry.getCosmetic(id);
        if (entry == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Cosmetic not found with ID: " + id)), false);
            return 1;
        }
        if (!Permissions.check((class_1297)player, (String)entry.permission(), (int)4)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Selected player does not have permission to use this cosmetic."), false);
            return 1;
        }
        class_1799 cosmeticItem = entry.itemStack();
        if (cosmeticItem == null || cosmeticItem.method_7960()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cosmetic item definition is empty or invalid."));
            return 1;
        }
        boolean isColorable = class_1802.field_18138.equals(class_7923.field_41178.method_10223(class_2960.method_12829((String)entry.baseItemForModel())));
        if (isColorable) {
            class_1799 itemForColorPicker = cosmeticItem.method_7972();
            itemForColorPicker.method_57381(class_9334.field_49644);
            new ColorPickerComponent(player, itemForColorPicker, coloredStack -> {
                new EquipCosmeticAction().execute(player, (class_1799)coloredStack, entry.type());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Equipped colored cosmetic: " + entry.displayName().getString())), false);
            }).open();
        } else {
            new EquipCosmeticAction().execute(player, entry.itemStack(), entry.type());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Equipped cosmetic: " + entry.displayName().getString())), false);
        }
        return 0;
    }

    public static int getSlotForType(ItemType type) {
        return switch (type) {
            case ItemType.HAT -> 5;
            case ItemType.CHESTPLATE -> 6;
            case ItemType.LEGGINGS -> 7;
            case ItemType.BOOTS -> 8;
            default -> throw new IllegalStateException("Unsupported item type for slot calculation: " + String.valueOf((Object)type));
        };
    }

    public static class_1799 getTiltedItemStack(class_1799 original, PolymerModelData polymerModel) {
        class_1799 itemStack = original.method_7972();
        ((IItemStack)itemStack).setItem(polymerModel.item());
        itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(polymerModel.value()));
        return itemStack;
    }

    public static List<Path> listFiles(Path dir) {
        List<Path> list;
        block9: {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                ServerCosmetics.LOGGER.warn("Attempted to list files in a non-directory: {}", (Object)dir);
                return Collections.emptyList();
            }
            Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);
            try {
                list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ServerCosmetics.LOGGER.error("Failed to list files in directory: {}", (Object)dir, (Object)e);
                    return Collections.emptyList();
                }
            }
            walk.close();
        }
        return list;
    }

    public static ItemType getItemTypeForSlot(int slot) {
        switch (slot) {
            case 5: {
                return ItemType.HAT;
            }
            case 6: {
                return ItemType.CHESTPLATE;
            }
            case 7: {
                return ItemType.LEGGINGS;
            }
            case 8: {
                return ItemType.BOOTS;
            }
        }
        return null;
    }
}

