/*
 * Decompiled with CFR 0.152.
 */
package com.zefir.servercosmetics.config;

import com.zefir.servercosmetics.config.AbstractGuiConfig;
import com.zefir.servercosmetics.gui.resources.GuiTextures;
import com.zefir.servercosmetics.util.Utils;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_2561;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.file.YamlFile;

public class ItemSkinsGUIConfig
extends AbstractGuiConfig {
    private static int itemSlot;

    public ItemSkinsGUIConfig() {
        super("ItemSkinsGUI.yml");
    }

    @Override
    protected String getGuiConfigHeader() {
        return "ItemSkins GUI Config File";
    }

    @Override
    protected void addSpecificDefaults(YamlFile file) {
        file.addDefault("slots.itemSlot", (Object)4);
        if (!file.contains("displaySlots")) {
            file.set("displaySlots", List.of(19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43));
        }
        file.addDefault("permissions.openGui", (Object)"servercosmetics.gui.itemskins");
    }

    @Override
    protected void loadSpecificConfig(YamlFile file) {
        itemSlot = file.getInt("slots.itemSlot");
    }

    @Override
    protected void addDefaultButtons(ConfigurationSection buttonsSection) {
        super.addDefaultButtons(buttonsSection);
        buttonDefaults.put("selectItem", Map.of("name", "<red>Select item", "item", "minecraft:barrier", "slotIndex", 4, "lore", List.of("<dark_red>Click on the item in your inventory below.", "", "", "")));
        buttonDefaults.forEach((buttonName, properties) -> ItemSkinsGUIConfig.addDefaultButtonToSection(buttonsSection, buttonName, properties));
    }

    @Override
    protected void loadAllNavigationButtons(YamlFile file) {
        super.loadAllNavigationButtons(file);
        this.loadNavigationButton(file, "selectItem");
    }

    @Override
    public class_2561 getGuiName() {
        return GuiTextures.ITEM_SKINS_MENU.apply(Utils.formatDisplayName(this.guiNameString));
    }

    @Generated
    public static int getItemSlot() {
        return itemSlot;
    }
}

